<?php
/**
 * This file is part of
 * pragmaMx - Web Content Management System.
 * Copyright by pragmaMx Developer Team - http://www.pragmamx.org
 *
 * pragmaMx is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * $Revision: 626 $
 * $Author: PragmaMx $
 * $Date: 2022-09-19 08:11:22 +0200 (Mo, 19. Sep 2022) $
 */

defined('mxMainFileLoaded') or die('access denied');

if (!mxGetAdminPref('radminsuper')) {
    return mxRedirect(adminUrl(), 'Access Denied');
}

/* Sprachdatei auswählen */
mxGetLangfile(__DIR__);

class backupmain {
 

    /* A constructor function. */
    function __construct($param=false)
    {
        $this->main($param);
    }

    /* Defining a function called main. */
    function main ($op=false)
    {
        $bc=load_class("Backup");
        $tb=load_class("AdminForm","adminBackup");   
        $cf = load_class("Config","Backup");
        $config=$cf->get();
        $zip = new ZipArchive();

        switch (TRUE) {
            case is_writable(PMX_DYNADATA_DIR. DS .'backup'.DS):
                $savepath = PMX_DYNADATA_DIR. DS .'backup'.DS;
                break;
            case is_writable(PMX_DYNADATA_DIR.DS):
                $savepath = PMX_DYNADATA_DIR.DS;
                break;	
            default:
                $savepath = PMX_BASE_PATH.DS;
        }

        $maxsize=($cf->getValue("maxsize","Backup")>0)?$cf->getValue("maxsize","Backup"):2;
        $seltable=array();
        $msg=array();
        
        switch(pmxAdminform::CheckButton())
        {
            case "backup":
                $maxsize= $_POST['maxsize'];
                $maxsize= ($maxsize)>30?30:$maxsize;
                $savepath=normalizePath($_POST['savepath']);
                $savefile=$_POST['savefile'];

                $tables=array();
                if ($_POST['optimize']==1) {
                    // erst tabellen optimieren
                    $ret=$bc->optimize_all();
                    //mxDebugFuncvars($ret);
                    $msg[]=mxText("_DB_BACKUP_24"). $ret['total_gain'];
                }
                $zipfiles=array();
                switch ($_POST['tablesoption']){
                    case "all":     // alle Tabellen
                        $zfile=$bc->backup($savefile, $savepath,NULL,$maxsize*1024*1024 );
                        $cf->setValue("maxsize",$maxsize,"Backup"); 
                        $zipfiles[]=$zfile;
                        $bc->writeMsg(mxText("_BACKUP_SUCCESS"),FALSE);
                        break;
                    case "important":     // nur das wichtige
                    case "sysonly":     // nur Systemtabellen
                    case "modonly":     // nur Modultabellen
                    case "useronly":     // nur Usertabellen

                            $zfile=$bc->backup($savefile, $savepath,$_POST['tablesoption'],$maxsize*1024*1024 );
                            $zipfiles[]=$zfile;
                            $bc->writeMsg(mxText("_BACKUP_SUCCESS"),FALSE);
                        break;
                    case "selected":     // alle selektierten Tabellen
                        if (array_key_exists('sel2',$_POST)) {
                            if (count($_POST['sel2']))	{				                                
                                $zfile=$bc->backup($savefile, $savepath,$_POST['sel2'],$maxsize*1024*1024 );
                                $zipfiles[]=$zfile;                            
                                $seltable=$_POST['sel2'];
                            }
                            $bc->writeMsg(mxText("_BACKUP_SUCCESS"),FALSE);
                            
                        } else {
                            $bc->writeMsg(mxText("_RETRIEVE_TABLES_FAIL"),true);
                        }
                        break; 
                }

                $msg1=$bc->get_messages();
                foreach ($msg1 as $key=>$ms){
                    $msg[]=$ms;
                }

                // im ZIP-Format speichern?
                if ($_POST['fileformat']=='ZIP'){
                    $ziperr=$zip->open($savepath.$savefile."_".$_POST['tablesoption'].".sql.zip", ZipArchive::CREATE);
                    //mxDebugFuncVars($zipfiles);
                    if ($ziperr===true) {
                        foreach($zipfiles as $zfile) {
                            $zip->addFile($savepath.$zfile,$zfile);
                        }
                        if ($zip->close()===true) {
                            foreach($zipfiles as $zfile) {
                            if (mx_is_writable($savepath.$zfile)) unlink($savepath.$zfile);
                            }
                        }

                    } else {
                        $bc->writeMsg(mxText("_ZIP_FILE_FAIL"),true);
                    }	
                }
                break;
                
            case "restore":
                $dest=PMX_DYNADATA_DIR.DS."tmp".DS."BC".mxUniqueID();
                $restfile="none";

                if ($_POST['setfile']==1) {
                    // ausgewählt aus liste
                    $restfile=$_POST['restorefile'];
                } else {
                    // hochgeladen 
                    foreach ($_FILES["extfile"]["error"] as $key => $error) {
                        if ($error == UPLOAD_ERR_OK) {
                            $tmp_name = $_FILES["extfile"]["tmp_name"][$key];
                            // basename() kann Directory-Traversal-Angriffe verhindern;
                            // weitere Validierung/Bereinigung des Dateinamens kann angebracht sein
                            $name = basename($_FILES["extfile"]["name"][$key]);
                        // mxDebugFuncVars($savepath,$name,$tmp_name);
                            move_uploaded_file($tmp_name, $savepath.$name);
                            $restfile=$savepath.$name;
                            
                        } else {
                            $bc->writeMsg(mxText("_DB_IMPORT_FAILED"),true);
                        }
                        
                    }
                    
                }
                if ($restfile !="none") {
                $ff = new finfo(FILEINFO_MIME_TYPE);
                    switch($ff->file($restfile))
                    {
                        case "application/zip":
                            
                            //mxDebugFuncvars($dest);
                            $this->unpackZip($dest,$restfile);
                            $files = array();
                            $filess =(array)glob($dest .DS.  '*.sql', GLOB_NOSORT);
                            foreach ($filess as $filename) 
                            {
                                $msg = $bc->restore($filename);
                            }
                            // verzeichnis und Inhalte wieder löschen
                            mx_rmdir($dest);
                            break;
                        case "text/plain":      //SQL text
                            $msg = $bc->restore($restfile);
                            break;
                    }
                } else {
                    $bc->writeMsg(mxText("_DB_OPTION6"),true);
                }
                
                $msg=$bc->get_messages();
            
            pmxHeader::add_body_script_code('$(document).ready(function(){$("#adminBackup-formtabs").tabs({ active: 1 });});');
            break;  
        }
            
        $savefile = pmxBase::dbname() . date("_Y_m_d_H_i_s", time()) .  '';
    
        $warning='<div id="restorepopupdialog" class="warning" title="'.mxText('_WARNING').'">'.mxText('_DO_NOT_REFRESH').'</div>';

        $tb->__set("tb_direction", 'right');
        $tb->__set("infobutton", false);
        $tb->__set("tb_pic_heigth", 25);
        $tb->__set("csstoolbar", "toolbar1");
        $tb->__set("cssform", "a304030");
        $tb->__set('buttontext', false);
        $tb->__set('homelink', false);
        $tb->__set('fieldhomebutton', true);
        $tb->__set('formtabs', true);
        $tb->__set('acceptbutton', false);
        
            
        $tb->add("","html",$warning);    
        $tb->addFieldset("backup",mxText("_DATABASE_SAVE"));
        $tb->addFieldset("restore",mxText("_DATABASE_RESTORE"));
        
        // backup 
        
        $msg_out=FALSE;
        //mxDebugFuncVars($msg);
        if (is_array($msg)) {
            foreach($msg as $text) {
                if (substr($text,0,5)=="ERROR") {
                    $tb->add("","error",$text);
                } else {
                    
                    $msg_out .=$text."</br>";
                }
            }
        } else {
            $msg_out .=$msg;
        }

        //mxDebugFuncvars($savepath,normalizePath($savepath));

        if ($msg_out) $tb->add("","output","<div id='a3658965' class='info'>".$msg_out."</div>");
        $tb->add("backup","output",mxText("_BACKUP_INFO_1"));
        $tb->add("backup","number","maxsize",$maxsize,mxText("_BACKUP_INFO_2"),mxText("_BACKUP_INFO_3"),2,
            'maxlength="2" min="1" max="30" step="1"');
        $tb->add("backup","path","savepath",normalizePath($savepath),_DB_BACKUP_10,_DB_BACKUP_11,30,30);
        $tb->add("backup","Input","savefile",$savefile,_DB_BACKUP_12,"",60,60);
        
        $tb->add("backup","select","fileformat",1,_DB_BACKUP_13,"",1,array(_DB_BACKUP_15=>"ZIP",_DB_BACKUP_16=>"SQL"));
        $tb->add("backup","yesno","optimize",1,_DB_BACKUP_23,);

            // TODO - Sprachkonstanten anlegen
        $tablesoptarray=array(_ALL=>"all",
                        _DB_OPTION1=>"important",
                        _DB_OPTION2=>"sysonly",
                        _DB_OPTION3 =>"modonly",
                        _DB_OPTION4=>"useronly",
                        _DB_OPTION5=>"selected",
        );

        $tb->add("backup","radiogroup","tablesoption","all",_DB_BACKUP_21,_DB_BACKUP_21_INFO,0,$tablesoptarray);    
        
        /* Tables */
        $tables=$bc->getTablesStatus();
        
        $totalsize=0;
        $table=array();
        foreach ($tables as $key=>$value) {

            //mxDebugFuncVars($key,$value,$table);
            $total = ($value['Data_length'] + $value['Index_length']) / 1024  ;
            $value['Size'] = round ($total, 3);
            $totalsize = $totalsize + $total;
            $table[$key." - ".$value['Size']." Byte"]=$value['Name'];
        }
        
        $totalsize=round($totalsize , 3);
        
        $tb->add("backup","select","sel2[]",$seltable,_DB_BACKUP_22,_DB_BACKUP_22_INFO,min(10,count($table)),$table);	
        $tb->add("backup","output",_DB_TOTALSIZE . $totalsize);
        $img_backup = mxCreateImage(PMX_IMAGE_DIR.DS."admin".DS."database_save.png");
        $img_restore = mxCreateImage(PMX_IMAGE_DIR.DS."admin".DS."database_refresh.png");
        $tb->add("backup","html",'<div class="align-center"><button type="submit" name="toolbarsubmit" value="backup" id="adminBackupbackup3" class="button" style="padding:20px;" title="'._DB_BACKUP_17.'">'.$img_backup."&nbsp;"._DB_BACKUP_17.'</button></div>');
        
        // Restore 
        $files=array();
        
        foreach ((array)glob($savepath. pmxBase::dbname().'*.sql*') as $filename) {
            if ($filename) {
                $files[str_replace($savepath,"",$filename)]=$filename;
            }
        }
        arsort($files);
        
        
        $tb->add("restore","hidden","restorefile","none");
        $tb->add("restore","output",mxText("_RESTORE_INFO_1"));
        $tb->add("restore","radio","setfile",1,mxText("_RESTORE_INFO_2"),"",1);
        $tb->add("restore","select","restorefile",_DB_BACKUP_12,"&nbsp;","",min(10,count($files)),$files);
        
        $tb->add("restore","radio","setfile",0,mxText("_RESTORE_INFO_3"));
        $tb->add("restore","file","extfile",1,mxText("_RESTORE_INFO_4"));
        $tb->add("restore","warning",mxText("_RESTORE_INFO_5"));

        $tb->add("restore","html",'<div class="align-center"><button type="submit" name="toolbarsubmit" value="restore" id="adminBackupbackup7" class="button " style="padding:20px;" title="'._RESTORE.'">'.$img_restore."&nbsp;"._RESTORE.'</button></div>');
        

        mxIncludeHeader();
        title(_SAVEDATABASE);

        echo $tb->show();
        
        mxIncludeFooter();    
        
    }

    /* A function that unzips a file. */
    function unpackZip ($dest, $zipfile)
    {
        $zip=new ZipArchive();
        if ($zip->open($zipfile,ZipArchive::RDONLY)) {
            if (!is_dir($dest)) {
                mkdir($dest, 0777, true);
            }
            if (is_writable($dest)){
                return $zip->extractTo($dest);
            }
        }
        return false;
    }
}

$c = new backupmain($op);
unset ($c);
