<?php
/**
 * This file is part of Theme for 
 * pragmaMx - Web Content Management System.
 *
 * $template: pmx_base $
 * $Revision: 1 $
 *
 * $Author: pragmaMx $
 * $Date: 2022-09-26 13:52:22 $
 */ 
 
defined('mxMainFileLoaded') or die('access denied');

/**
 * Definition der jeweiligen Platzhalter und deren Ersetzungen
 */
function theme_define_placeholders()
{
    global $themesetting,$theme_mobile,$sitename;
    $part[] = array("{RESPONSIVE}", ((MX_MOBILE_DEVICE)?"":""));
	$part[] = array("{PAGE_TITLE}", $themesetting['sitename']);
    $part[] = array("{PAGE_SLOGAN}", $themesetting['slogan']);
    $part[] = array("{DEBUGSERVICE}", theme_get_servicetext('debugservice'));
    $part[] = array("{SITESERVICE}", theme_get_servicetext('siteservice'));
    $part[] = array("{LAYOUT_CLASS}", theme_get_layout_class() );
    $part[] = array("{CURRENTYEAR}", date('Y'));
	$part[] = array("{CURRENTTIME}", mx_strftime(_TIMEFORMAT));
	$part[] = array("{CURRENTDATE}", mx_strftime(_DATESTRING));
    $part[] = array("{FOOTMESSAGE}", theme_show_footmsg());
    $part[] = array("{RSSTAG}", theme_get_rss_tag());
    $part[] = array("{FACEBOOKTAG}", theme_get_facebook_tag());
	$part[] = array("{TWITTERTAG}", theme_get_twitter_tag());
	$part[] = array("{USERONLINE}", theme_total_user_online()." "._THEME_USERONLINE);
	$part[] = array("{LANGUAGEFLAGS}", theme_show_languageflags());
	$part[] = array("{LOGINFORM}", theme_loginform());
	$part[] = array("{LOGINFORMV}", theme_loginform(1));
	$part[] = array("{FOOT_MENU}", theme_footer_menu());
	$part[] = array("{TOP_MENU}", theme_top_menu());
	$part[] = array("{TOPBLOCK}", theme_show_banner(3));
	$part[] = array("{BOTTOMBLOCK}", theme_show_banner(4));
	$part[] = array("{TOP_TEXT}", $themesetting['top_text']);
	$part[] = array("{FOOT_TEXT}", $themesetting['foot_text']);
	$part[] = array("{HEADERTEXT}", $themesetting['headertext']);
	$part[] = array("{CONTENT_FOOT_TEXT}", $themesetting['content_foot_text']);
	$part[] = array("{THEMEADMIN}", theme_admin());
	$part[] = array("{COPYRIGHTS}","&copy;&nbsp;".date('Y')."&nbsp;".$sitename."");
	$part[] = array("{HEADROW}",theme_others("headline.html"));
	$part[] = array("{FOOT_OTHER}",theme_others("footother.html"));	
	$part[] = array("{SOCIALLINKS}", theme_social_links());
	$part[] = array("{SEARCHFORM}", theme_search_form());
	
	if ($themesetting['breadcrump']) {
		$part[] = array("{CURRENTPATH}", theme_show_currentpath());
    }else {
        $part[] = array("{CURRENTPATH}", "");
    }
	
	if ($themesetting['head_css_menu']) {
        $part[] = array("{NAVBAR}", theme_mxmenu());
    } else {
        $part[] = array("{NAVBAR}", theme_get_navbars(1));
    }

    if ($themesetting['banner']['head']) {
        $part[] = array("{BANNER_HEAD}", theme_show_banner(1)); # 1 = HeaderBanner
    } else {
		$part[] = array("{BANNER_HEAD}","");
	}

    if ($themesetting['banner']['foot']) {
        $part[] = array("{BANNER_FOOT}", theme_show_banner(2)); # 2 = FooterBanner
    } else {
		$part[] = array("{BANNER_FOOT}","");
	}
    return $part;
}

function theme_admin () 
{

	return (MX_IS_ADMIN)?'<div class="theme_admin"><a href="admin.php?op=themes&act=admin&theme='._THISTHEMENAME_.'" >[Theme Admin]</a></div>':'';
}

function theme_search_form ()
{
	if (!mxModuleAllowed('Search')) return "";
	$a='<form action="modules.php?name=Search" method="get" class="search" style="width:100%">
			<input type="hidden" value="Search" name="name" />
			<span class="noscreen">Fulltext:</span>
			<input id="search-input" type="text" name="query" maxlenght="30" size="10" style="width:100px;"/>&nbsp;
			<input id="search-submit" type="submit" value="'._SEARCH.'" style="left:110px;"/>
			</form>';
	return $a;
}

/**
 * mx_theme_loginform()
 * Benutzerspezifische Anzeigen im Kopfbereich
 *
 * @return
 */
function theme_loginform($nr=0)
{
    global $JPCACHE_ON;
	$nr=intval($nr);
	
	if (!mxModuleAllowed('Your_Account')) return "";
    
	if ($JPCACHE_ON) {
        return;
    }

    $tpl = load_class('Template');
    $tpl->set_path(MX_THEME_DIR."/templates/");
	
    if (!MX_IS_USER) {
        defined('mxloginblockviewed') OR define('mxloginblockviewed', true);
        switch ($nr) {
			case 1:
			return $tpl->fetch('loginform1.html');
			break;
			default:
			return $tpl->fetch('loginform.html');
			break;
		}
    }

    if (MX_IS_USER) {
        $hookitems = pmx_get_usernews();
        $userentries = array();
        foreach ($hookitems as $entry) {
            $userentries[$entry['link']] = $entry['text'];
        }
        $username = mxSessionGetVar('user_uname');
        $tpl = load_class('Template');
        $tpl->set_path(MX_THEME_DIR."/templates/");
        $tpl->assign(compact('userentries', 'username'));

        switch ($nr) {
			case 1:
			return $tpl->fetch('hellouser1.html');
			break;
			default:
			return $tpl->fetch('hellouser.html');
			break;
		} 
		
    }
}


function theme_get_rss_tag()
{
	global $themesetting;
	if (trim($themesetting['rsslink'])!="") {
		return '<a href="'.$themesetting['rsslink'].'" target="_blank" title="my RSS-Feed" class="rss-tag-icon" style="line-height: 32px; "></a>';
	} else {
		return "";
	}
}

function theme_get_facebook_tag()
{
	global $themesetting;
	if (trim($themesetting['facebooklink'])!="") {
		return '<a href="'.$themesetting['facebooklink'].'" target="_blank" title="Facebook" class="facebook-tag-icon" style="line-height: 32px; "></a>';
	} else {
		return "";
	}
}

function theme_get_twitter_tag()
{
	global $themesetting;
	if (trim($themesetting['twitterlink'])!="") {
		return '<a href="'.$themesetting['twitterlink'].'" target="_blank" title="Twitter" class="twitter-tag-icon" style="line-height: 32px; "></a>';
	} else {
		return "";
	}
}
/**
 * Definition der einzelnen Blockbereiche
 */
function theme_define_blocks()
{
    global $themesetting;
    static $var;
    if (isset($var)) return $var;
    // linke Bloecke
    $name = 'block_left';
    $var[$name]['container'] = 'blocks_left_loop';
    $var[$name]['function'] = 'themesidebox';
    $var[$name]['position'] = 'l';
    /* einfache Moeglichkeit, die linken Bloecke bei bestimmten Seiten zu entfernen */
    if (theme_hideleftblocks() && MX_MODULE != 'admin') {
        unset($var[$name]);
    }
    // obere Center-Bloecke
    $name = 'block_center_top';
    $var[$name]['container'] = 'blocks_center_top_loop';
    $var[$name]['function'] = 'thememiddlebox';
    $var[$name]['position'] = 'c';

	//   
			$name = 'perex';
			$var[$name]['container'] = 'perex_loop';
			$var[$name]['function'] = 'theme_perex';
			$var[$name]['position'] = 'd';
			
    
    // untere Center-Bloecke
    $name = 'block_center_down';
    $var[$name]['container'] = 'blocks_center_down_loop';
    $var[$name]['function'] = 'thememiddlebox';
    $var[$name]['position'] = 'd';
	
    // rechte Bloecke
    $name = 'block_right';
    $var[$name]['container'] = 'blocks_right_loop';
    $var[$name]['function'] = 'themesidebox';
    $var[$name]['position'] = 'r';
	
	
    return $var;
}

/**
 * Definition des Contentbereiches inkl. der open/close-Table Funktionen
 */
function theme_define_content()
{
    static $var;
    if (isset($var)) return $var;
    // die Funktion OpenTable()
    $var['opentabs']['OpenTable']['templatevar'] = 'opentable';
    $var['opentabs']['OpenTable']['innerreplace'] = '{OPENCLOSE_TABLE}'; // hier kann irgendwas stehen, es muss aber mit dem entsprechenden Text innerhalb der template-Datei uebereinstimmen...
    // die Funktion OpenTable2()
    $var['opentabs']['OpenTable2']['templatevar'] = 'opentable2';
    $var['opentabs']['OpenTable2']['innerreplace'] = '{OPENCLOSE_TABLE_2}';
    // die Funktion OpenTableAl()
    $var['opentabs']['OpenTableAl']['templatevar'] = 'opentableal';
    $var['opentabs']['OpenTableAl']['innerreplace'] = '{OPENCLOSE_TABLE_AL}';
    // die Funktion themeindex() / News Modul
    $var['themeindex'] = 'themeindex';
    // die Funktion themearticle() / News Modul
    $var['themearticle'] = 'themearticle';
    // der Name (output_container) darf nicht veraendert werden !!
    $var['output_container'] = 'script_output';
    // der Name (index_on_container) darf nicht veraendert werden !!
    $var['index_on_container'] = 'blocks_right_container';
    $var['index_on_block_container'] = 'blocks_right_loop';
    // der Name (more_header) darf nicht veraendert werden !!
    $var['add_header'] = 'more_header';

    return $var;
}

/**
 * ersetzen von eigenen Theme-Elementen, kann veraendert und ergaenzt werden
 * diese Teile werden gleich zu Beginn des scriptes, beim einlesen des templates, ersetzt
 * Vorsicht, wenn das Theme gecached werden soll!!!
 * Dann duerfen hier keine dynamischen Elemente eingesetzt werden.
 */
function theme_replace_start($template)
{
    /**
     * bestimmte Texte, vor allem Image-Pfade, die ersetzt werden sollen, definieren (suche/ersetze)
     */
    $part[] = array('"style/', '"' . MX_THEME_DIR . '/style/'); // die Stylesheets
    $part[] = array('"images/', '"' . MX_THEME_DIR . '/images/'); // normale images im theme
    // $part[] = array('url(images/', 'url(' . MX_THEME_DIR . '/images/');
    // $part[] = array('"js/', '"' . MX_THEME_DIR . '/js/');
    // Suchformular entfernen, wenn Suche abgeschaltet ist
    if (!mxModuleAllowed('Search')) {
        theme_extract_optional_part($template, 'searchform', '<br />');
    }
    // Siteservicebereich entfernen, wenn Siteservice abgeschaltet oder leer ist
    if (!theme_get_servicetext('siteservice')) {
        theme_extract_optional_part($template, 'siteservice', '');
    }
    // Debugbereich entfernen, wenn Debugmodus abgeschaltet oder leer ist
    if (!theme_get_servicetext('debugservice')) {
        theme_extract_optional_part($template, 'debugservice', '');
    }
    // das Kopfmenue durch die tatsaechlichen Daten ersetzen
    theme_extract_optional_part($template, 'headmenue', '{NAVBAR}');

    return theme_replace_parts($template, $part);
}

/**
 * ersetzen von eigenen Theme-Elementen, kann veraendert und ergaenzt werden
 * diese Teile werden vor der Ausgabe des headers im Headbereich ersetzt
 */
function theme_replace_header($newheader)
{
    /* doppelte Zeilenumbrueche und fuehrende Leerzeichen entfernen */
    $newheader = preg_replace('#\n+(\s+)?#', "\n", $newheader);

    return $newheader;
}

/**
 * ersetzen in jedem einzelnen Block
 */
function theme_replace_blocks($template, $block)
{
    /*
    global $themesetting;
    switch (true) {
        case !($block['position'] === 'l' || $block['position'] === 'r'):

            break;
        case strpos($block['blockfile'], 'block-Modules') === 0:
        case $block['blockfile'] === 'block-Menu.php':
        case preg_match('#<ul[^>]*class[^>]*' . preg_quote($themesetting['blocknav']['style']) . '[^>]*>#i', $block['content']):
            $template = '<div class="' . $themesetting['blocknav']['style'] . '">' . $template . '</div>';
            break;
    }
*/
    /* Teil fuer alle Bloecke */
    if (empty($block['title']) || $block['title'] == 'NOTITLE') {
        //$part[] = array('__BLOCK_ID__' , '__BLOCK_ID__ block-hide-caption');
    }
    $part[] = array('__BLOCK_ID__' , 'block-' . $block['position'] . '-' . $block['order']);

    if (isset($part)) {
        return theme_replace_parts($template, $part);
    }
    return $template;
}

/**
 * ersetzen von eigenen Theme-Elementen, kann veraendert und ergaenzt werden
 * diese Teile werden am Ende des scriptes, in der Funktion themefooter() ersetzt
 */
function theme_replace_end($template)
{
    global $themesetting;

    /* einfache Moeglichkeit, die linken Bloecke bei bestimmten Seiten zu entfernen */
    if (theme_hideleftblocks()) {
        theme_extract_part($template, 'blocks_left_container');
    }

    if (isset($part)) {
        return theme_replace_parts($template, $part);
    }
    return $template;
}

/**
 * Die verschiedenen Layout-Spalten definieren
 */
function theme_get_layout_class()
{
    switch (true) {
        case theme_hidesideblocks():
        case theme_hiderightblocks() && theme_hideleftblocks():
            // einspaltiges Layout
            return 'hideboth';

        case theme_hiderightblocks():
            // zweispaltiges Layout, links ist aber rechts!!
            return 'leftonly';

        case theme_hideleftblocks():
            // zweispaltiges Layout, rechts ist aber links!!
            return 'rightonly';

        default:
            // dreispaltiges Layout > Standard
            return 'all';
    }
}

/**
 * pruefen ob linke Bloecke ausgeblendet werden sollen
 */
function theme_hideleftblocks()
{
    global $themesetting;
    if ((pmxBase::get('hide_left_blocks')==1) || (isset($themesetting['hide-left']) && in_array(1, $themesetting['hide-left'])) || theme_hidesideblocks()) {
        return true;
    }
    $blocks = mxGetAllBlocks('l');
    if (!$blocks) {
        // für nächsten Aufruf vereinfachen
        $themesetting['hide-left'][] = 1;
        return true;
    }
    return false;
}

/**
 * pruefen ob rechte Bloecke ausgeblendet werden sollen
 */
function theme_hiderightblocks()
{
    global $themesetting;
    if (empty((pmxBase::get('hide_right_blocks')==1) || $GLOBALS['index']) || theme_hidesideblocks() || in_array(1, $themesetting['hide-right'])) {
        return true;
    }
    $blocks = mxGetAllBlocks('r');
    if (!$blocks) {
        // f�r n�chsten Aufruf vereinfachen
        $GLOBALS['index'] = false;
        return true;
    }
    return false;
}

/**
 * pruefen ob beide Bloecke ausgeblendet werden sollen
 */
function theme_hidesideblocks()
{
    global $themesetting;
    return (isset($themesetting['hide-both']) && in_array(1, $themesetting['hide-both']));
}

/* die Navigationsbuttons im header, Quelle in settings.php */
function theme_get_navbars($number)
{
    global $themesetting;
    static $out;
    // if (isset($out[$number])) {
        // return $out[$number];
    // }
    $data = theme_head_data();
    $count = count($data[$number]) - 1;
    foreach ($data[$number] as $key => $menue) {
        switch (true) {
            case ($menue['current'] && ($key == 0)):
                /* aktuelle Seite und erster Tab */
                $class = ' class="active first"';
                break;
            case ($key == 0):
                /* irgendeine Seite und erster Tab */
                $class = ' class="first"';
                break;
            case ($menue['current'] && ($key == $count)):
                /* aktuelle Seite und letzter Tab */
                $class = ' class="active last"';
                break;
            case ($menue['current']):
                /* aktuelle Seite und irgendein Tab */
                $class = ' class="active"';
                break;
            case ($key == $count):
                /* irgendeine Seite und letzter Tab */
                $class = ' class="last"';
                break;
            default:
                /* irgendeine Seite und irgendein Tab */
                $class = '';
        }
        $slogan = (empty($menue['slogan'])) ? '' : ' title="' . $menue['slogan'] . '"';
        $navbar[] = '<li><a href="' . $menue['link'] . '"' . $class . $slogan . '>' . $menue['caption'] . '</a></li>';
    }
    $out[$number] = '<ul >' . $class .  implode("\n", $navbar) . '</ul>';
    return $out[$number];
}

function theme_head_data()
{
    global $themesetting;
    static $out;
    if (isset($out)) {
        return $out;
    }
    $out['current'] = array();
    foreach ($themesetting['headnav'] as $key => $values) {
        $values['current'] = false;
        if (in_array(1, $values['case'])) {
            $out['current'] = $values;
            $values['current'] = true;
        }
        if ($values['menu']) {
            $values['index'] = $key;
            $out[$values['menu']][] = $values;
        }
    }
    return $out;
}

/**
 * in $newheader ist der gesamte angepasste header enthalten
 */
function theme_header($newheader, &$siteservice, &$debugservice)
{
    global $theme_template, $themesetting;
    /* das Theme verwendet eigene Servicebereiche, deswegen hier die beiden Variablen killen */
    $siteservice = null;
    $debugservice = null;
    /* den body-Tag hinter head-Ende setzen >> nicht veraendern !! */
    $newheader .= "\n</head>\n\n" . $theme_template['body_tag'] . "\n\n";
    /* bei Bedarf den XHTML-Dokumenttyp ueberpruefen und Fehlermeldung ausgeben */
    if (MX_IS_ADMIN && !theme_check_xhtmldoctype()) {
        $newheader .= '<div class="warning"><h2 class="align-center">' . _THEME_FALSEDOCTYPE . '</h2></div>';
    }
    // ersetzen von eigenen Theme-Elementen, kann veraendert und ergaenzt werden
    // diese Teile werden vor der Ausgabe des headers im Headbereich ersetzt
    $newheader = theme_replace_header($newheader);

    return $newheader;
}

/**
 * parsen der Seiten-Bloecke
 */
function themesidebox($title, $content, $block = array(), $noecho = 0)
{
    global $theme_template;
    if (empty($block)) {
        $block['position'] = 'l';
    }
    $out = ($block['position'] == 'r') ? $theme_template['block_right'] : $theme_template['block_left'];
    $out = str_replace('{BLOCK_CONTENT}' , $content , $out);
    $out = str_replace('{BLOCK_TITLE}' , $title , $out);
    if ($noecho) {
        return $out;
    } else {
        echo $out;
    }
}

/**
 * Perex (der erste oberste Block) auslesen
 */
function theme_perex($title, $content, $block = array(), $noecho = 0)
{
    global $theme_template, $themesetting;

    static $c_perex =0;

    if ($themesetting['perex']) {
        switch ($c_perex) {
            case 0:
                $c_perex=1;
                $out = $theme_template['perex'];
                $out = str_replace('{PEREX_TITLE}' , $title , $out);
                $out = str_replace('{PEREX_CONTENT}' , $content , $out);
                if ($noecho) {
                    return $out;
                }
                echo $out;
            default:
                return '';
        }
    }
}

/**
 * parsen der Center-Bloecke
 */
function thememiddlebox($title, $content, $block = array(), $noecho = 0)
{
    global $theme_template, $themesetting;

    static $c_perex =0;
	
    $out = '';
    switch (true) {
        case empty($block):
        case empty($block['position']):
        case $block['position'] === 'c':
            $block['position'] = 'c';
            $out = $theme_template['block_center_top'];
            break;

        case $block['position'] === 'd'  && $c_perex < 1 && $noecho === 'noecho':
            // 'noecho' wird nur in mx-themes zugefügt, so wird perex in Blockpreview u.A. nicht verwendet
            //$themesetting['c_perex']++;
            return '';

        case $block['position'] === 'd' && ( $block['weight']>1 or $themesetting['perex']==0):
            $out = $theme_template['block_center_down'];
            break;
    }
	
	$c_perex++;
	
	if ($out) {
		$out = str_replace('{BLOCK_CONTENT}' , $content , $out);
		$out = str_replace('{BLOCK_TITLE}' , $title , $out);
	}
    if ($noecho) {
        return $out;
    } else {
        echo $out;
    }
}

/**
 * News Modul Artikelliste (index.php)
 * $x bedeutet: nicht verwendet, nur zur nuke-Modulkompatibilitaet
 */
function themeindex($x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8, $x9, $x10, $x11, $story = array())
{
    global $theme_template;
   //pmxHeader::add_style(MX_THEME_DIR . '/style/news.css');
    // nur eine Spalte zulassen :-)
    $GLOBALS['storyhome_cols'] = 1;
    $cattitle = (empty($story['cattitle'])) ? '' : ' <span class="story-cat-title">(' . $story['allmorelink']['categorie'] . ')</span>';
    $authorinfo = (empty($story['informant']) || $story['informant'] == $GLOBALS['anonymous']) ? theme_adminname($story) : " " . $story['allmorelink']['informantlink'] . $story['informant'] . "</a>";
    $story['topicimage'] = '<a href="modules.php?name=News&amp;topic=' . $story['topic'] . '">' . mxCreateImage($GLOBALS['tipath'] . $story['topicimage'], $story['topictext'], array('title' => _TOPIC . ': ' . $story['topictext'], 'align' => 'left', 'class' => 'story-topicimage')) . '</a>';
    $story['title'] = strip_tags($story['title']) . $cattitle;
    $story['content'] = $story['hometext'];
	$story['buttons'] = implode('</li><li>', getThemeIndexButtons($story));
    if (!$story['acomm'] && $GLOBALS['articlecomm']) { // Achtung!!! acomm: 0 = Ja , 1 = Nein
        $story['comments'] = '<a href="modules.php?name=News&amp;file=article&amp;sid=' . $story['sid'] . '#comments" class="story-footer-comments postcommentsicon">' . _COMMENTS . ' (' . $story['comments'] . ')</a>';
    } else {
        $story['comments'] = '';
    }
    if (empty($story['allmorelink']['bodycount'])) {
        $story['readmore'] = '';
    } else {
        $title = ($story['allmorelink']['bodycount']) ? ' title="' . $story['allmorelink']['bodycount'] . ' ' . _BYTESMORE . '"' : '';
        $story['readmore'] = '<a href="modules.php?name=News&amp;file=article&amp;sid=' . $story['sid'] . '" class="button story-footer-readmore"' . $title . '>' . _HREADMORE . '</a>';
    }
    $story['datetime'] = '<span class="postdateicon">' . $story['datetime'] . '</span>';
    $story['infoline'] = ($GLOBALS['storyhome_cols'] == 1) ? _NEWSSUBMITED . " <span class='postauthoricon'>" . $authorinfo . "</span>&npsp;&nbsp;<span class='postdateicon'>" . $story['allmorelink']['datetime']."</span>" : $story['datetime'];
    // die oben definierten Variablen in dem passenden templateteil ersetzen
    $artvars = theme_define_content();
    echo theme_replace_vars($theme_template[$artvars['themeindex']], $story);
    return;
}

/**
 * News Modul Artikelansicht (article.php)
 * $x bedeutet: nicht verwendet, nur zur nuke-Modulkompatibilitaet
 */
function themearticle($x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8, $story = array())
{
    global $theme_template;
    pmxHeader::add_style(MX_THEME_DIR . '/style/news.css');
    $authorinfo = (empty($story['informant']) || $story['informant'] == $GLOBALS['anonymous']) ? theme_adminname($story) : " " . $story['allmorelink']['informantlink'] . $story['informant'] . "</a>";
    $story['infoline'] = _NEWSSUBMITED . " <span class='postauthoricon'>" . $authorinfo . "</span> <span class='postdateicon'>" . $story['allmorelink']['datetime']."</span>";
    $story['topicimage'] = '<a href="modules.php?name=News&amp;topic=' . $story['topic'] . '">' . mxCreateImage($GLOBALS['tipath'] . $story['topicimage'], $story['topictext'], array('title' => _TOPIC . ': ' . $story['topictext'], 'align' => 'left', 'class' => 'story-topicimage')) . '</a>';
    $story['title'] = strip_tags($story['title']);
    $story['content'] = $story['hometext'] . "\n" . $story['bodytext'];
    $story['notes'] = (empty($story['notes'])) ? '' : '<p class="story-notes page-footer">' . _NOTE . '</p><p>' . $story['notes'] . '</p>';
    // die oben definierten Variablen in dem passenden templateteil ersetzen
    echo theme_replace_vars($theme_template['themearticle'], $story);
    return;
}

function theme_mxmenu()
{
    global $themesetting;
	if (trim($themesetting['head_css_menu'])=="") return "";
	
    load_class('Menu', false);


	if (pmxBase::language()== pmxBase::currentlang()) {
		$menu = pmxMenu::get_menu_instance($themesetting['head_css_menu']);
		$menuname=$themesetting['head_css_menu'];
	} else {
		$menu = pmxMenu::get_menu_instance($themesetting['head_css_menu']."_"._DOC_LANGUAGE);
		$menuname=$themesetting['head_css_menu']."_"._DOC_LANGUAGE;
	}
	if (!$menu->get_tree()) {
		$menu = pmxMenu::get_menu_instance($themesetting['head_css_menu']);
		$menuname=$themesetting['head_css_menu'];
	}

    $menu->template_path = MX_THEME_DIR."/templates/";
    $menu->template = 'menu.tpl.html';
    $menu->class_sublevel = '';
	
    if (MX_IS_ADMIN && !$menu->get_tree()) {
        return '<div class="warning">' . sprintf(_THEME_MENU_NOT_EXIST, $menuname) . ' [<a href="admin.php?op=menu">' . _MX_MENU_ADDMENU_EDIT . '</a>]</div>';
    }

    $content = $menu->fetch();
    $menu = null;

    return $content;
}

function theme_footer_menu()
{
    global $themesetting;

	if (trim($themesetting['foot_css_menu']=="")) return "";
	
    load_class('Menu', false);

	if (pmxBase::language()== pmxBase::currentlang()) {
		$menu = pmxMenu::get_menu_instance($themesetting['foot_css_menu']);
		$menuname=$themesetting['foot_css_menu'];
	} else {
		$menu = pmxMenu::get_menu_instance($themesetting['foot_css_menu']."_"._DOC_LANGUAGE);
		$menuname=$themesetting['foot_css_menu']."_"._DOC_LANGUAGE;
	}
	if (!$menu->get_tree()) {
		$menu = pmxMenu::get_menu_instance($themesetting['foot_css_menu']);
		$menuname=$themesetting['foot_css_menu'];
	}
	
    $menu->template_path = MX_THEME_DIR."/templates/";
    $menu->template = 'vmenu.tpl.html';
    $menu->class_sublevel = '';
    if (MX_IS_ADMIN && !$menu->get_tree()) {
        return '<div class="warning">' . sprintf(_THEME_MENU_NOT_EXIST, $menuname) . ' [<a href="admin.php?op=menu">' . _MX_MENU_ADDMENU_EDIT . '</a>]</div>';
    }

    $content = $menu->fetch();
    $menu = null;
    return $content;
}

function theme_top_menu()
{
    global $themesetting;
	if (trim($themesetting['top_css_menu'])=="") return "";
	
    load_class('Menu', false);

    $menu = pmxMenu::get_menu_instance($themesetting['top_css_menu']);
    $menu->template_path = MX_THEME_DIR."/templates/";
    $menu->template = 'topmenu.tpl.html';
    $menu->class_sublevel = '';
    if (MX_IS_ADMIN && !$menu->get_tree()) {
        return '<div class="warning">' . sprintf(_THEME_MENU_NOT_EXIST, $themesetting['top_css_menu']) . ' [<a href="admin.php?op=menu">' . _MX_MENU_ADDMENU_EDIT . '</a>]</div>';
    }

    $content = $menu->fetch();
    $menu = null;

    return $content;
}

/**
 * Die Navigationsbuttons in der Artikelliste des Newsmoduls
 */
function getThemeIndexButtons($story)
{
    global $theme_template;
    static $img, $isnewsadmin;
    if (!isset($isnewsadmin)) {
        $isnewsadmin = mxGetAdminPref('radminarticle');
    }
    if (empty($img)) {
        // die images werden in einen statischen Variable gehalten um die Bildgroessen nicht bei jedem Artikel zu ermitteln
        // xx als alttext wird weiter unten dynamisch ersetzt
        $img[1] = mxCreateImage(MX_THEME_DIR . '/style/images/postauthoricon.png', 'xx', array('title' => 'xx'));
        $img[2] = mxCreateImage(MX_THEME_DIR . '/style/images/postprinticon.png', _BMXPRINTER, array('title' => _BMXPRINTER));
        $img[3] = mxCreateImage(MX_THEME_DIR . '/style/images/postemailicon.png', _BMXFRIEND, array('title' => _BMXFRIEND));
        $img[4] = mxCreateImage(MX_THEME_DIR . '/style/images/postcategoryicon.png', 'xx', array('title' => 'xx'));
        $img[6] = mxCreateImage(MX_THEME_DIR . '/style/images/posttagicon.png', 'xx', array('title' => 'xx'));
        if ($GLOBALS['articlecomm']) $img[5] = mxCreateImage(MX_THEME_DIR . '/style/images/postcommentsicon.png', 'xx', array('title' => 'xx'));
        // mxdebugfuncvars($story['allmorelink']); // zum ansehen der morelink-Parameter einkommentieren
        // mxdebugfuncvars($story);                // zum ansehen der story-Parameter der ersten story einkommentieren
    }
    // mxdebugfuncvars($story);                  // zum ansehen der story-Parameter aller stories einkommentieren
    $bmore = ($story['allmorelink']['bodycount']) ? _READMORE . " (" . $story['allmorelink']['bodycount'] . ' ' . _BYTESMORE . ")" : _READMORE;
    $adminlink = ($isnewsadmin) ? " href='admin.php?op=News/EditStory&amp;sid=" . $story['sid'] . "' " : "";
    $link[] = $story['allmorelink']['storylink'] . str_replace("xx", $bmore, $img[6]) . "</a>";
    if ($story['informant'] != $GLOBALS['anonymous'] && (MX_IS_USER || MX_IS_ADMIN)) {
        $link[] = $story['allmorelink']['informantlink'] . str_replace("xx", _USERINFO . ": " . $story['informant'], $img[1]) . "</a>";
    }
    $link[] = $story['allmorelink']['printerlink'] . $img[2] . "</a>";
    if (mxModuleAllowed('Recommend_Us')) {
        $link[] = $story['allmorelink']['friendlink'] . $img[3] . "</a>";
    }
    if (empty($story['acomm']) && $GLOBALS['articlecomm']) { // Achtung!!! acomm: 0 = Ja , 1 = Nein
        $link[] = $story['allmorelink']['commentslink'] . str_replace("xx", _COMMENTS . " (" . $story['comments'] . ")", $img[5]) . "</a>";
    }
    $link[] = "<a title='" . $story['allmorelink']['counter'] . ", " . $story['allmorelink']['score'] . "' " . $adminlink . ">" . str_replace("xx", $story['counter'] . ' ' . _READS, $img[4]) . "</a>";
    return $link;
}

/*
 läd angegebene HTML-Datei und gibt den inhalt zurück. 
*/
function theme_others ($filename, $tpath=MX_THEME_DIR."/templates/")
{
	/*$tpath=MX_THEME_DIR."/templates/";*/
	
	if (file_exists($tpath.$filename))	{
	    $tpl = load_class('Template');
		$tpl->set_path($tpath);
		return $tpl->fetch($filename);
	}
	return "";
}


function theme_social_links ()
{
	global $themesetting;
	//mxDebugFuncVars($themesetting['sociallinks']);
	if (!array_key_exists('sociallinks',$themesetting) or !array($themesetting['sociallinks'])) return "";
	$content="<div class='sociallinks'>";
	foreach ($themesetting['sociallinks'] as $channel=>$value)
	{ 
		$mythemepath=PMX_THEMES_DIR . DS. _THISTHEMENAME_ . DS ;
		$found=false;
		if (trim($value)) {
			switch (true){
				case file_exists($imagesrc= $mythemepath."images".DS."social".DS.$themesetting['socialsets']. DS . $channel .".png"):
				$found=true;
				break;
				case file_exists($imagesrc= $mythemepath."style".DS."images".DS."social".DS.$themesetting['socialsets']. DS . $channel .".png"):
				$found=true;
				break;
			}	
			if ($found){
				$linkimage=mxCreateImage($imagesrc);
				$content .=(true)?'<a href="'.$value.'" title="'.$channel.'" >'.$linkimage.'</a>	':""; 
			}
		}
	}
	return $content."</div>";
	
}
?>