<?php
/**
 * This file is part of
 *
 * SiriusGallery
 *
 * for pragmamx (www.pragmamx.org)
 *
 * $Revision: 597 $
 * $Author: PragmaMx $
 * $Date: 2022-08-31 19:47:13 +0200 (Mi, 31. Aug 2022) $
 */


defined("mxAdminFileLoaded") or die("Access Denied");

$module_name = basename(dirname(dirname(__FILE__)));

define("SG_ADMINLOAD", true);
global $siriusgallery_version;
// Sprachdateien einbinden
mxGetLangfile($module_name);
mxGetLangfile($module_name, "admin.lang-*.php");
mxGetLangfile($module_name, "exif.lang-*.php");
mxGetLangfile($module_name, "upload.lang-*.php");
load_class("AdminForm", false);
// eigene Includes einbinden
include(PMX_MODULES_DIR . DS . $module_name . DS . "inc" . DS . "tabledef.php");

//include(PMX_SYSTEM_DIR . DS . "tecmu" . DS . "functions.tecmu.php");
include(PMX_MODULES_DIR . DS . $module_name . DS . "inc" . DS . "functions.php");
include(PMX_MODULES_DIR . DS . $module_name . DS . "inc" . DS . "functions.sirius.php");
include(PMX_MODULES_DIR . DS . $module_name . DS . "inc" . DS . "functions.forms.php");
include(PMX_MODULES_DIR . DS . $module_name . DS . "inc" . DS . "functions.toolbar.php");
include(PMX_MODULES_DIR . DS . $module_name . DS . "inc" . DS . "functions.exif.php");
include(PMX_MODULES_DIR . DS . $module_name . DS . "inc" . DS . "functions.upload.php");

if (empty($ok)) $ok = 0;
if (empty($cat)) $cat = 0;
if (empty($pic)) $pic = 0;
if (empty($listlen)) $listlen = 0;
if (empty($start)) $start = 0;
if (empty($sort)) $sort = 0;
if (empty($sortpublished)) $sortpublished = 0;
if (empty($met)) $met = 0;

if (!isset($act)) $act = "" ;

(version_compare(PMX_VERSION, '2.8.', '>=')) or die('Sorry, PMX Version >= 2.8. is required for this SiriusGallery-Version');

include(PMX_MODULES_DIR . DS . $module_name . DS . "inc" . DS . "install.tabledef.sg.php");

sg_checktables($act);
if ($act == "install") {
    include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_install.php");
    exit;
}

$SGCFG = getConfigAll();
include_once(PMX_MODULES_DIR . DS . DS . $module_name . DS . "setup.pmx.php");
$sg_credits=$credits();
/* check auf updates */
if (($SGCFG['VERSION'] != $sg_credits['version']) AND $met == 0) {
    include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_install.php");
    exit;
}



if ($act == "uninstall") {
    sql_query("DROP TABLE " . SG_TABLE_PICTURE . ", " . SG_TABLE_CONFIG . ", " . SG_TABLE_COMMENT . ", " . SG_TABLE_CATEGORY . ", " . SG_TABLE_VOTES . ";");
    mxRedirect("admin.php?op=$module_name");
}

switch ($act) {
    case "info":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_info.php");
        break;
    case "tools":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_tools.php");
        break;
    case "config":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_config.php");
        sg_config();
        break;
    case "upload":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_upload.php");
        admin_upload($met);
        break;
    case "uploadsave":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_upload.php");
        admin_upload_save();
        break;
    case "multiupload":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_upload.php");
        admin_multiupload();
        break;
    case "multiuploadsave":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_upload.php");
        admin_multiupload();
        break;
    case "ftpupload":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_upload.php");
        admin_upload_ftp();
        break;
    case "ftpuploadsave":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_upload.php");
        admin_upload_ftpsave();
        break;
    case "images":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_pictures.php");
        admin_pictures($cat, $start, $sort, $sortpublished);
        break;
    case "imagesinfo":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_pictures.php");
        sg_imagesInfo($pic);
        break;
    case "comments":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_comments.php");
        admin_comments($cat, $start, $sort, $sortpublished);
        break;
    case "commentpublish":
        sg_setCommentPublish($pic);
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_comments.php");
        admin_comments($cat, $start, $sort, $sortpublished);
        break;
    case "commentunpublish":
        sg_setCommentUnpublish($pic);
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_comments.php");
        admin_comments($cat, $start, $sort, $sortpublished);
        break;
    case "commentdelete":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_comments.php");
        sg_commentdelete($pic, $ok);
        break;
    case "imagespublish":
        sg_setImagePublish($pic);
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_pictures.php");
        admin_pictures($cat, $start, $sort);
        break;
    case "imagesunpublish":
        sg_setImageUnpublish($pic);
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_pictures.php");
        admin_pictures($cat, $start, $sort);
        break;
    case "imagesedit":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_pictures.php");
        sg_imagesedit($pic);
        break;
    case "imageseditmore":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_pictures.php");
        sg_imageseditmore($pic, $ok);
        break;
    case "imagesdelete":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_pictures.php");
        sg_imagesdelete($pic, $ok);
        break;
    case "imgresize":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_pictures.php");
        sg_imagesresize($pic, $ok);
        break;
    case "imagescopy":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_pictures.php");
        sg_imagescopy($pic, $ok);
        break;
    case "imagesmove":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_pictures.php");
        sg_imagesmove($pic, $ok);
        break;
    case "imagesclone":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_pictures.php");
        sg_imagesclone($pic, $ok);
        break;
    case "category":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_category.php");
        sg_category();
        break;
    case "categoryedit":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_category.php");
        sg_categoryedit($cat);
        break;
    case "categorydelete":
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_category.php");
        sg_categorydelete($cat, $ok);
        break;
    case "categorypublish":
        sg_setCategoryPublish($cat);
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_category.php");
        sg_category();
        break;
    case "categoryunpublish":
        sg_setCategoryUnpublish($cat, $ok);
        include(PMX_MODULES_DIR . DS . $module_name . DS . "admin" . DS . "admin_category.php");
        sg_category();
        break;
    case "activate":
	    sg_setmoduleactive();
    default:
        sg_main();
        break;
}

function sg_main()
{
    global $prefix, $user_prefix, $currentlang, $module_name, $bgcolor1, $bgcolor2, $bgcolor3, $toolbarpicheigth, $toolbarpicpath, $SGCFG, $siriusgallery_version;
    // Abfragen Userdaten für letztes login
    if (MX_IS_ADMIN && MX_IS_USER) {
        $udata = mxGetUserSession();
    }

    switch (toolbarCheckButton()) {
        case "upload":
            mxRedirect("admin.php?op=$module_name&act=upload");

            break;
        case "categorys":
            mxRedirect("admin.php?op=$module_name&act=category");

            break;
        case "settings":
            mxRedirect("admin.php?op=$module_name&act=config");
            break;
        case "images":
            mxRedirect("admin.php?op=$module_name&act=images");
            break;
        case "comments":
            mxRedirect("admin.php?op=$module_name&act=comments");
            break;
        case "tools":
            mxRedirect("admin.php?op=$module_name&act=tools");
            break;
    }
    mxIncludeHeader();
	pmxHeader::add_style("modules/".PMX_MODULE."/style/style.css");


    $img_cpanel = mxCreateImage(PMX_MODULES_PATH . $module_name . "/style/siriusgallery.png", _ADMIN_INFO);

    $titelzeile = "<div><table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
                 <tr><td width=\"50\">$img_cpanel</td>
                 <td align=\"left\" valign=\"middle\" width=\"100%\"><h2>Sirius Gallery</h2></td></tr></table></div>";

    echo $titelzeile;
    echo (!mxModuleActive($module_name))?"<div class=\"error\">" . _MODULENOTACTIVE . " <a href=\"admin.php?op=".$module_name."&amp;act=activate\" class=\"button\" >"._ACTIVATE."</a></div>":"";
	
    $tb = load_class('AdminForm', "setup");
    $tb->__set("tb_direction", 'left');
    $tb->__set("infobutton", false);
    $tb->__set("tb_pic_heigth", 50);
    $tb->__set("csstoolbar", "toolbar1 toolbarfixed");
    //$tb->__set("tb_text", _ADMINPANELTEXT);
    $tb->__set("fieldhomebutton", false);
    $tb->__set("homelink", false);

    $toolbarpicpath = PMX_MODULES_PATH . $module_name . "/style/";

    $tb->addToolbarLink("images", "admin.php?op=$module_name&amp;act=images", _IMAGE_MANAGER, $toolbarpicpath . 'image.png');
    $tb->addToolbarLink("categorys", "admin.php?op=$module_name&amp;act=category", _CATEGORIES, $toolbarpicpath . 'categorys.png');
    $tb->addToolbarLink("comments", "admin.php?op=$module_name&amp;act=comments", _COMMENTS, $toolbarpicpath . 'comments.png');
    $tb->addToolbarLink("upload", "admin.php?op=$module_name&amp;act=upload", _UPLOAD_MANAGER, $toolbarpicpath . 'upload.png');
    $tb->addToolbarLink("tools", "admin.php?op=$module_name&amp;act=tools", _TOOLS, $toolbarpicpath . 'tools.png');
    $tb->addToolbarLink("settings", "admin.php?op=$module_name&amp;act=config", _SETTINGS, $toolbarpicpath . 'settings.png');
    echo $tb->Show();

    $result = sql_query("select count(pid) from " . SG_TABLE_PICTURE . " where published='-1'");
    list($newpic) = sql_fetch_row($result);
    unset($result);
    $result = sql_query("select count(id) from " . SG_TABLE_COMMENT . " where publish='-1'");
    list($newcoms) = sql_fetch_row($result);
    unset($result);
    if ($newpic > 0 or $newcoms > 0) {
        echo "<div class=\"info align-center\">";
        if ($newpic > 0) echo "<a href=\"admin.php?op=$module_name&amp;act=images&amp;sortpublished=3\" >" . $newpic . " " . _SG_PIC_WAITING . "</a><br />";
        if ($newcoms > 0) echo "<a href=\"admin.php?op=$module_name&amp;act=comments&amp;sortpublished=3\" >" . $newcoms . " " . _SG_COMMENTS_WAITING . "</a>";
        echo "</div><br/>";
    }

    //include("modules" . DS . $module_name . DS . "setup.pmx.php");
	echo mxcredit_shortinfo("modules" . DS . $module_name . DS . "setup.pmx.php");
   // echo "<p class=\"box align-center\" >SiriusGallery - Version : $siriusgallery_version</p>";

    tmb_copyright();

    include("footer.php");
}

function sg_checktables($act)
{
    global $module_name;
	$tables=array();
    $result = sql_query("SHOW TABLES");
    while (list($tablename) = sql_fetch_row($result)) {
        $tables[] = $tablename;
    }
	
    if (!in_array(SG_TABLE_CATEGORY, $tables) && ($act != "install")) {
        mxRedirect("admin.php?op=$module_name&act=install");
		die();
    }
    unset($tables);
	
    return $act;
}
function sg_setmoduleactive($active=1) {
    global $doc_cfg, $module_name, $credits, $setup_result, $prefix, $doc;
	mxSetModuleActive($module_name,$active);
	return;
}
?>