<?php
/**
 * This file is part of
 * pragmaMx - Web Content Management System.
 * Copyright by pragmaMx Developer Team - http://www.pragmamx.org
 *
 * pragmaMx is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * $Revision: 5 $
 * $Author: PragmaMx $
 * $Date: 2021-02-12 22:27:49 +0100 (Fr, 12. Feb 2021) $
 */

defined('mxMainFileLoaded') or die('access denied');
unset($sqlqry);

/* ab pragmaMx 2.6 */
// --------------------------------------------------------
// Tabellenstruktur fuer Tabelle `_plugins`
if (!isset($tables["{$prefix}_plugins"])) {
    $sqlqry[] = "
CREATE TABLE `{$prefix}_plugins` (
  `id` int(11) NOT NULL,
  `active` int(11) DEFAULT NULL COMMENT '1=Active',
  `position` int(11) NOT NULL COMMENT 'Reihenfolge der Bearbeitung',
  `type` varchar(64) COLLATE utf8_unicode_ci NOT NULL COMMENT 'type des Plugins - entspricht dem aufgerufenen plugin-Namens',
  `processing` int(11) DEFAULT NULL COMMENT 'wo wird ausgeführt, 0=Frontend, 1=Backend, 2 =beides',
  `plugin_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Name des Plugin-Moduls',
  `name` text COLLATE utf8_unicode_ci NOT NULL COMMENT 'angezeigter Name',
  `description` text COLLATE utf8_unicode_ci NOT NULL COMMENT 'Beschreibung',
  `admin_menu` tinyint(1) DEFAULT NULL COMMENT 'Menueintrag im Adminmenu vorhanden',
  `image` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'evtl. Bild',
  `version` varchar(32) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Version',
  `settings` text COLLATE utf8_unicode_ci NOT NULL COMMENT 'Configuration des Plugins',
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'url des entwicklers'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
";

	$sqlqry[] = "ALTER TABLE `{$prefix}_plugins`  ADD PRIMARY KEY (`id`), ADD KEY `active` (`active`),   ADD KEY `position` (`position`),  ADD KEY `type`(`type`),  ADD KEY `processing` (`processing`);";

	$sqlqry[] = "ALTER TABLE `{$prefix}_plugins` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;";
}
	

	
if (isset($sqlqry)) {
    setupDoAllQueries($sqlqry);
    unset($sqlqry);
}

?>
