<?php
/**
 * This file is part of
 * pragmaMx - Web Content Management System.
 * Copyright by pragmaMx Developer Team - http://www.pragmamx.org
 *
 * pragmaMx is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * $Revision: 1151 $
 * $Author: PragmaMx $
 * $Date: 2025-06-14 12:53:03 +0200 (Sa, 14. Jun 2025) $
 *
 *
 * Based on Journey Links Hack
 * Copyright (c) 2000 by James Knickelbein
 * Journey Milwaukee (http://www.journeymilwaukee.com)
 */

defined('mxMainFileLoaded') or die('access denied');

if (!$usevoting) {
    mxRedirect('modules.php?name=' . $module_name, _NOTVOTINGWARN, 5);
}

function rating($lid, $msg = array())
{
    global $prefix, $module_name, $usecomments, $pagetitle;
    if (!modCheckAndCleanSubdata($lid)) {
        mxRedirect('modules.php?name=' . $module_name);
    }
    // Daten fuer header aufbereiten
    $result = sql_query("SELECT title FROM " . $prefix . "_links_links WHERE lid = " . intval($lid) . " AND cid > 0");
    list($title) = sql_fetch_row($result);
    // $title = _RATETHISSITE . ':&nbsp;' . $title;
    $pagetitle = strip_tags($title . ', ' . _LINKRATING);
    $pagesubmenu = modDetailsTopMenu($lid);

    include(PMX_MODULES_DIR . DS . $module_name . '/includes/header.php');
    OpenTable();
    echo '<h4 class="option">' . _LINKRATING . '</h4>';
    if (!empty($msg) && is_array($msg)) {
        openTableAl();
        echo '<div style="text-align: left;"><h2>' . _ERROROCCURS . '</h2><ul><li>' . implode('</li><li>', $msg) . '</li></ul></div>';
        closeTableAl();
        echo '<br />';
    }
    echo "<ul>"
     . "<li>" . _RATENOTE1 . "</li>"
     . "<li>" . _RATENOTE2 . "</li>"
     . "<li>" . _RATENOTE3 . "</li>"
     . "<li>" . _DRATENOTE4 . "</li>"
     . "<li>" . _RATENOTE5 . "</li>";
    if (MX_IS_USER) {
        $cookie = mxGetUserSession();
        $auth_name = $cookie[1];
        echo "<li>" . _YOUAREREGGED . "</li>"
         . "<li>" . _FEELFREE2ADD . "</li>";
    } else {
        echo "<li>" . _YOUARENOTREGGED . "</li>"
         . "<li>" . _IFYOUWEREREG . "</li>";
        $auth_name = $GLOBALS['anonymous'];
    }

    $comment = ($usecomments && isset($_POST['ratingcomments'])) ? stripslashes($_POST['ratingcomments']) : '';
    $rating = (isset($_POST['rating'])) ? intval($_POST['rating']) : 0;
    $options = '<option value="0">--</option>';
    for ($i = 1; $i <= 10; $i++) {
        $sel = ($i == $rating) ? ' selected="selected" class="current"' : '';
        $options .= '<option value="' . $i . '"' . $sel . '>' . $i . '</option>';
    }
    echo "</ul>"
     . "<form method=\"post\" action=\"modules.php?name=" . $module_name . "&amp;op=view&amp;lid=" . $lid . "\">"
     . "<input type=\"hidden\" name=\"ratinglid\" value=\"" . $lid . "\" />"
     . "<input type=\"hidden\" name=\"ratinguser\" value=\"" . mxpreparetodisplay($auth_name) . "\" />"
     . "<input type=\"hidden\" name=\"op\" value=\"addrating\" />"
     . "<input type=\"hidden\" name=\"name\" value=\"" . $module_name . "\" />"
     . "<b>" . _RATING . ":</b>&nbsp;"
     . "<select name=\"rating\">" . $options . "</select>"
     . '<br /><br />';

    if (MX_IS_USER && $usecomments) {
        $editor = load_class('Textarea', array('name' => 'ratingcomments', 'value' => $comment, 'mode' => 'mini', 'height' => '150'));
        $captcha_object = load_class('Captcha', 'commentson');

        echo "<b>" . _ADDACOMMENT . ":</b><br />";
        $editor->show();
        if ($captcha_object->get_active()) {
            echo ''
             . '<div>' . $captcha_object->complete() . '</div>'
             . '<br /><br />';
        }
    } else {
        echo "<input type=\"hidden\" name=\"ratingcomments\" value=\"\" />";
    }

    echo "<input type=\"submit\" value=\"" . _RATETHISSITE . "\" />"
     . "</form>";
    CloseTable();
    include(PMX_MODULES_DIR . DS . $module_name . '/includes/footer.php');
}

function addrating()
{
    global $prefix, $module_name, $pagetitle;
    global $anonwaitdays, $outsidewaitdays, $useoutsidevoting, $usecomments;

    $lid = (empty($_POST['ratinglid'])) ? 0 : intval($_POST['ratinglid']);
    if (!modCheckAndCleanSubdata($lid)) {
        mxRedirect('modules.php?name=' . $module_name);
    }

    extract($_POST);
    if (MX_IS_USER) {
        $cookie = mxGetUserSession();
        $ratinguser = $cookie[1];
    } else if ($ratinguser == "outside") {
        $ratinguser = "outside";
    } else {
        $ratinguser = $GLOBALS['anonymous'];
    }
    // TODO: Kommentare zulassen, auch wenn bereits abgestimmt wurde, Bewertung dann nicht zaehlen
    $rating = (empty($_POST['rating'])) ? 0 : intval($_POST['rating']);
    $rating = ($rating > 10) ? 10 : $rating;
    $msg = array();
    $newchance = false;
    /**
     * Make sure only 1 anonymous from an IP in a single day.
     * Check if Rating is Null
     */
    if (empty($rating) || $rating < 1) {
        $msg[] = _COMPLETEVOTE5;
        $newchance = true;
    }

    $ratingcomments = (empty($ratingcomments) || empty($usecomments)) ? '' : $ratingcomments;
    // wenn Captcha fuer Kommentare erforderlich und Kommentar geschrieben wurde
    if ($ratingcomments) {
        $captcha_object = load_class('Captcha', 'commentson');
        if (!$captcha_object->check($_POST, 'captcha')) {
            $msg[] = _CAPTCHAWRONG;
            $newchance = true;
        }
    }

    /**
     * Check if Link POSTER is voting (UNLESS Anonymous users allowed to post)
     */
    if ($ratinguser != $GLOBALS['anonymous'] && $ratinguser != "outside") {
        $result = sql_query("select submitter from " . $prefix . "_links_links where lid=" . intval($lid) . " AND cid > 0");
        while (list($ratinguserDB) = sql_fetch_row($result)) {
            if ($ratinguserDB == $ratinguser) {
                $msg[] = _COMPLETEVOTE4;
                $newchance = false;
                break;
            }
        }
    }
    /**
     * Check if REG user is trying to vote twice.
     */
    if ($ratinguser != $GLOBALS['anonymous'] && $ratinguser != "outside") {
        $result = sql_query("select ratinguser from " . $prefix . "_links_votedata where ratinglid=" . intval($lid));
        while (list($ratinguserDB) = sql_fetch_row($result)) {
            if ($ratinguserDB == $ratinguser) {
                $msg[] = _COMPLETEVOTE3;
                $newchance = false;
                break;
            }
        }
    }
    /**
     * Check if ANONYMOUS user is trying to vote more than once per day.
     */
    if ($ratinguser == $GLOBALS['anonymous']) {
        $yesterdaytimestamp = (time() - (86400 * intval($anonwaitdays)));
        $ytsDB = Date("Y-m-d H:i:s", $yesterdaytimestamp);
        $result = sql_query("select * FROM " . $prefix . "_links_votedata WHERE ratinglid=" . intval($lid) . " AND ratinguser='" . $GLOBALS['anonymous'] . "' AND ratinghostname = '" . MX_REMOTE_ADDR . "' AND TO_DAYS(NOW()) - TO_DAYS(ratingtimestamp) < " . intval($anonwaitdays));
        $anonvotecount = sql_num_rows($result);
        if ($anonvotecount >= 1) {
            $msg[] = _COMPLETEVOTE2;
            $newchance = false;
        }
    }
    /**
     * Check if OUTSIDE user is trying to vote more than once per day.
     */
    if ($ratinguser == "outside") {
        $yesterdaytimestamp = (time() - (86400 * intval($outsidewaitdays)));
        $ytsDB = Date("Y-m-d H:i:s", $yesterdaytimestamp);
        $result = sql_query("select * FROM " . $prefix . "_links_votedata WHERE ratinglid=" . intval($lid) . " AND ratinguser='outside' AND ratinghostname = '" . MX_REMOTE_ADDR . "' AND TO_DAYS(NOW()) - TO_DAYS(ratingtimestamp) < " . intval($outsidewaitdays));
        $outsidevotecount = sql_num_rows($result);
        if (intval($outsidevotecount) >= 1 || !$useoutsidevoting) {
            $msg[] = _COMPLETEVOTE6;
            $newchance = false;
        }
    }

    /**
     * Passed Tests
     */
    if (empty($msg)) {
        /**
         * All is well.  Add to Line Item Rate to DB.
         */
        $ok = sql_query("INSERT into " . $prefix . "_links_votedata values (NULL,'" . intval($lid) . "', '" . mxAddSlashesForSQL($ratinguser) . "', '" . intval($rating) . "', '" . MX_REMOTE_ADDR . "', '" . mxAddSlashesForSQL($ratingcomments) . "', now())");
        if ($ok && $ratingcomments && !empty($GLOBALS['notifycomment'])) {
            $message = _HELLO . ",\n" . sprintf(''
                 . _COMMENTSNOTIFY, $GLOBALS['sitename']) . "\n\n"
             . "========================================================\n"
             . $ratinguser . " " . _WRITES . ": (" . $rating . ")\n\n"
             . $ratingcomments . "\n\n"
             . "========================================================\n"
             . PMX_HOME_URL . '/modules.php?name=' . $module_name . '&op=view&lid=' . $lid . "\n\n" ;
            mxMail($GLOBALS['notify_email'], $GLOBALS['notify_subject'], $message, $GLOBALS['notify_from']);
        }

        /**
         * All is well.  Calculate Score & Add to Summary (for quick retrieval & sorting) to DB.
         * NOTE: If weight is modified, ALL links need to be refreshed with new weight.
         * Running a SQL statement with your modded calc for ALL links will accomplish this.
         */
        $voteresult = sql_query("select rating, ratinguser, ratingcomments FROM " . $prefix . "_links_votedata WHERE ratinglid = " . intval($lid));
        $totalvotesDB = sql_num_rows($voteresult);
        include(PMX_MODULES_DIR . DS . $module_name . "/includes/voteinclude.php");
        if (!is_numeric($finalrating) || !is_numeric($totalvotesDB) || !is_numeric($truecomments) || !is_numeric($lid)) {
            mxRedirect('modules.php?name=' . $module_name . '&amp;op=view&amp;lid=' . $lid);
        }
        sql_query("UPDATE " . $prefix . "_links_links SET linkratingsummary=" . $finalrating . ",totalvotes=" . $totalvotesDB . ",totalcomments=" . $truecomments . " WHERE lid = " . intval($lid) . " AND cid > 0");
    } else if ($newchance) {
        // Formular erneut anzeigen
        rating($lid, $msg);
        return;
    }
    // Fehler bassiert :(
    if (!empty($msg)) {
        // Daten fuer header aufbereiten
        $result = sql_query("SELECT lid, title FROM " . $prefix . "_links_links WHERE lid=" . intval($lid) . " AND cid > 0");
        list($lid, $title) = sql_fetch_row($result);
        $pagetitle = strip_tags($title . ', ' . _LINKRATING);
        $pagesubmenu = modDetailsTopMenu($lid, 'addrating');

        include(PMX_MODULES_DIR . DS . $module_name . '/includes/header.php');
        OpenTable();
        echo '<h4 class="option">' . _LINKRATING . '</h4>';
        openTableAl();
        echo '<div style="text-align: left;"><h2>' . _ERROROCCURS . '</h2><ul><li>' . implode('</li><li>', $msg) . '</li></ul></div>';
        closeTableAl();
        echo "<br /><br /><br />";
        CloseTable();
        include(PMX_MODULES_DIR . DS . $module_name . '/includes/footer.php');
    } else {
        $msg = "<p class=\"content\"><b>" . _COMPLETEVOTE1 . "</b></p>";
        $msg .= "<p class=\"content\">" . _THANKSTOTAKETIME . '<br />' . _WLETSDECIDE . "</p>";
        mxRedirect('modules.php?name=' . $module_name . '&amp;op=view&amp;lid=' . $lid, $msg, 6);
    }
}

?>