<?php
/**
 * This file is part of
 * pragmaMx - Web Content Management System.
 * Copyright by pragmaMx Developer Team - http://www.pragmamx.org
 *
 * pragmaMx is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * $Revision: 1151 $
 * $Author: PragmaMx $
 * $Date: 2025-06-14 12:53:03 +0200 (Sa, 14. Jun 2025) $
 *
 * this file based on:
 * TPK Recommend us
 * Copyright (c) 2002 by Jochem Schausten (webmaster@phpnuke-module.de), http://www.phpnuke-module.de
 * Copyright (C) 2003 by Future (info@powerfiles.de), http://www.PowerFiles.de
 * php-nuke Web Portal System - http://phpnuke.org/
 * Thatware - http://thatware.org/
 */

defined('mxMainFileLoaded') or die('access denied');

$module_name = basename(dirname(__FILE__));
mxGetLangfile($module_name);
$pagetitle = _RECOMMEND;
// / rechte Bloecke anzeigen?
// / 0 = nein, 1 = ja
$index = 0;
pmxBase::set("plugins",0);
/**
 * das Formular
 */
function RecommendSite($event = array())
{
    if (isset($event['more'])) {
        $tmp = mxSecureValue(unserialize(base64_decode($event['more'])), true);
        if (is_array($tmp)) {
            $event['yname'] = $tmp['yname'];
            $event['ymail'] = $tmp['ymail'];
        }
    }

    if (MX_IS_USER && empty($event['yname']) && empty($event['ymail'])) {
        $uinfo = mxGetUserData();
        $event['yname'] = $uinfo['uname'];
        $event['ymail'] = $uinfo['email'];
    }
    include_once("header.php");
    title(_RECOMMEND);
    if (isset($event['recerror'])) {
        openTableAl();
        echo '<div style="text-align: left;"><h2>' . _RECERRORTITLE . '</h2><ul><li>' . implode('</li><li>', $event['recerror']) . '</li></ul></div>';
        closeTableAl();
        echo '<br />';
    }
    OpenTable();
    echo "<form action=\"modules.php?name=" . $GLOBALS['module_name'] . "\" method=\"post\" name=\"sendform\">"
     . "<input type=\"hidden\" name=\"name\" value=\"" . $GLOBALS['module_name'] . "\" />"
     . "<input type=\"hidden\" name=\"op\" value=\"SendSite\" />"
     . "<input type=\"hidden\" name=\"site\" value=\"" . $_SERVER['HTTP_REFERER'] . "\" />"
     . "<table class=\"form\">"
     . "<tr><td>" . _RECFRIENDNAME . " </td><td> <input type=\"text\" name=\"fname\" value=\"" . (isset($event['fname']) ? mxentityquotes($event['fname']): '') . "\" size=\"35\" /></td></tr>\n"
     . "<tr><td>" . _RECFRIENDEMAIL . " </td><td> <input type=\"text\" name=\"fmail\" value=\"" . (isset($event['fmail']) ? mxentityquotes($event['fmail']): '') . "\" size=\"35\" /></td></tr>\n"
     . "<tr valign=\"top\"><td>" . _RECREMARKS . " </td><td><textarea name=\"ftext\" cols=\"35\" rows=\"5\">" . (isset($event['ftext']) ? mxEntityQuotes(strip_tags($event['ftext'])): '') . "</textarea></td></tr>\n"
     . "<tr><td>" . _RECYOURNAME . " </td><td> <input type=\"text\" name=\"yname\" value=\"" . (!empty($event['yname']) ? mxentityquotes($event['yname']): '') . "\" size=\"35\" /></td></tr>\n"
     . "<tr><td>" . _RECYOUREMAIL . " </td><td> <input type=\"text\" name=\"ymail\" value=\"" . (!empty($event['ymail']) ? mxentityquotes($event['ymail']): '') . "\" size=\"35\" /></td></tr>\n"
     . "";
    // captcha anzeigen
    $captcha_object = load_class('Captcha', 'recommendon');
    if ($captcha_object->get_active()) {
        echo '<tr><td>&nbsp;</td><td><div>' . $captcha_object->complete() . '</div></td></tr>' . "\n"
         . "\n";
    }
    echo "<tr><td colspan=\"2\" align=\"center\"><br /><input type=\"submit\" value=\"" . _SEND . "\" />";
 
    echo "</td></tr></table>"
     . "</form>\n";
	 echo "<p class=\"note align-center\">" . sprintf(mxText("_IPRECORDED"), MX_REMOTE_ADDR) . "</p>\n";
    CloseTable();
    include_once('footer.php');
}

/**
 * Die Verarbeitung und Fehlerprüfung
 */
function SendSite()
{
    global $sitename, $prefix, $module_name;

    $event = mxStripSlashes($_POST);

    if (empty($event['yname'])) {
        $event['recerror'][] = _RECERRORNAME;
    }

    switch (true) {
        case empty($event['ymail']):
        case !mxCheckEmail($event['ymail']):
            $event['recerror'][] = _RECERRORSENDER;
            break;
        case pmx_is_mail_banned($event['ymail']):
            $event['recerror'][] = _RECERRORSENDER . ' (' . _MAILISBLOCKED . ')';
    }

    switch (true) {
        case empty($event['fmail']):
        case !mxCheckEmail($event['fmail']):
            $event['recerror'][] = _RECERRORRECEIVER;
            break;
        case pmx_is_mail_banned($event['fmail']):
            $event['recerror'][] = _RECERRORRECEIVER . ' (' . _MAILISBLOCKED . ')';
    }

    $captcha_object = load_class('Captcha', 'recommendon');
    if (!$captcha_object->check($_POST, 'captcha')) {
        $event['recerror'][] = _CAPTCHAWRONG;
    }

    if (isset($event['recerror'])) {
        RecommendSite($event);
    } else {
        if (MX_IS_USER) {
            $usersession = mxGetUserSession();
        } else {
            $usersession[0] = 0;
        }
        $event['ftext'] = (empty($event['ftext'])) ? "" : "" . $event['ftext'] . "\n\n\n";
        $subject = _RECINTSITE . " $sitename";
        $message = _HELLO . " " . $event['fname'] . ":\n\n" . _RECYOURFRIEND . " " . $event['yname'] . " " . _RECOURSITE . " \"$sitename\" " . _RECINTSENT . "\n\n\n" . $event['ftext'] . _RECSITENAME . " $sitename\n" . _RECSITEURL . " " . PMX_HOME_URL . "\n";
        $message = strip_tags($message);
        if (mxMail($event['fmail'], $subject, $message, $event['ymail'], "text", "", $event['yname'])) {
            sql_query("INSERT INTO " . $prefix . "_recommend VALUES (NULL,'" . mxAddSlashesForSQL(strip_tags($event['fname'])) . "','" . $event['fmail'] . "','" . mxAddSlashesForSQL(strip_tags($event['yname'])) . "','" . $event['ymail'] . "','" . $usersession[0] . "','" . mxAddSlashesForSQL(MX_REMOTE_ADDR) . "','" . time() . "','" . mxAddSlashesForSQL(strip_tags($event['site'])) . "')");
        }
        // das ist nur eine Dummy-Weiterleitung um das Aktualisieren der Seite zu verhindern
        unset($event['op'], $event['name'], $event['ftext'], $event['site']);
        $event = base64_encode(serialize($event));
        mxRedirect('modules.php?name=' . $module_name . '&op=SiteSent&more=' . $event, '', 0);
    }
}

/**
 * das ist nur eine Dummy-Weiterleitung um das Aktualisieren der Seite zu verhindern
 */
function SiteSent()
{
    global $module_name;
    $more = isset($_GET['more']) ? $_GET['more'] : '';
    if ($more) {
        $tmp = mxSecureValue(unserialize(base64_decode($more)), true);
        $fname = $tmp['fname'];
    } else {
        $fname = '?';
    }
    $msg = _RECREFERENCE . " " . $fname . "...<br /><br />" . _RECTHANKS;
    mxRedirect('modules.php?name=' . $module_name . '&amp;more=' . $more, $msg, 5);
}

/**
 * Auswahl der Optionen
 */
$op = (isset($_REQUEST['op'])) ? $_REQUEST['op'] : "";
switch ($op) {
    case 'SendSite':
        SendSite();
        break;

    case 'SiteSent':
        SiteSent();
        break;

    default:
        RecommendSite($_GET);
        break;
}

?>