<?php
/**
* This file is part of
* pragmaMx - Web Content Management System.
* Copyright by pragmaMx Developer Team - http://www.pragmamx.org
*
* pragmaMx is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* $Revision: 1151 $
* $Author: PragmaMx $
* $Date: 2025-06-14 12:53:03 +0200 (Sa, 14. Jun 2025) $
*
* this file based on:
* CZ Enhanced Feedback
* Copyright (c) 2004 by ~ Telli ~ (telli@codezwiz.com)
* http://www.marsishere.net
* edited by H.Grunert, http://www.marx-city.de
* php-nuke Web Portal System - http://phpnuke.org/
* Thatware - http://thatware.org/
*/

defined('mxMainFileLoaded') or die('access denied');

$module_name = basename(dirname(__DIR__));
global $mxfbcfg;

/**
* Konfiguration auslesen
*/

function feedback_config() {
  global $prefix;
  $mxfbcfg = array();
  $sql = "SELECT * FROM " . $prefix . "_mxfeedback_config";
  $result = sql_query($sql);
  while (list($config_name, $config_value) = sql_fetch_row($result)) {
    $mxfbcfg[$config_name] = $config_value;
  }
  return $mxfbcfg;
}

/**
* das komplette Eingabeformular
*/
function feedbackform() {
  global $module_name,
  $mxfbcfg,
  $numdepts,
  $prefix;
  global $lname,
  $fname,
  $email,
  $subject,
  $message,
  $preselected,
  $sendcopy;
  $req = "&nbsp;<b class=\"required\">*</b>";
  $module_name = basename(dirname(__DIR__));
  $numdepts = feedback_DeptCount();
  $captcha_object = load_class('Captcha', 'feedbackon');

  $message = (!is_string($message))?"":$message;
  //OpenTable();
  echo '<p class="content">' . sprintf(_FEEDBACKNOTE, $GLOBALS['sitename']) . '</p>'
  . '<p class="align-right">' . $req . '&nbsp;' . _INDICATESREQ . '</p>';
  echo "<form action=\"modules.php?name=" . $module_name . "&amp;op=check\" name=\"feedbackform\" method=\"post\" onsubmit=\"return chkFeedbackFormular();\">\n"
  . "<table cellpadding=\"3\" cellspacing=\"0\">\n";
  if (($numdepts > 0) && ($mxfbcfg['deptson'] == "1")) {
    $sql = "SELECT * FROM " . $prefix . "_mxfeedback_depts ORDER BY dname ASC";
    $result = sql_query($sql);
    echo "<tr valign=\"top\"><td> " . _SERVICESELECT . ":</td><td>\n"
    . "<select name=\"deptemail\">\n"
    . "<option value=\"\" selected=\"selected\" disabled=\"disabled\">&nbsp;</option>\n";
    while ($row = sql_fetch_assoc($result)) {
      if ($row['dname'] == $preselected) {
        echo "<option selected=\"selected\" class=\"current\" value=\"" . $row['did'] . "\">" . $row['dname'] . "</option>\n";
      } else {
        echo "<option value=\"" . $row['did'] . "\">" . $row['dname'] . "</option>\n";
      }
    }
    echo "</select>" . $req . "</td></tr>\n";
  }
  // Automatically required
  echo "<tr valign=\"top\"><td>" . _YOURFIRSTNAME . " :</td>\n";
  echo "<td><input type=\"text\" name=\"fname\" size=\"35\" value=\"" . mxEntityQuotes($fname) . "\" />" . $req . "</td></tr>\n";
  // Last Name required?
  if ($mxfbcfg['reqlname'] == "1") {
    echo "<tr valign=\"top\"><td>" . _YOURLASTNAME . " :</td>\n";
    echo "<td><input type=\"text\" name=\"lname\" size=\"35\" value=\"" . mxEntityQuotes($lname) . "\" />" . $req . "</td></tr>\n";
  }
  // Automatically required

  echo "<tr valign=\"top\"><td>" . _YOUREMAIL . " :</td>\n";
  echo "<td><input type=\"text\" name=\"email21\" size=\"35\" value=\"" . mxEntityQuotes($email) . "\" />" . $req . "</td></tr>\n";
  // Automatically required - Subject, Message
  echo "<tr valign=\"top\"><td>" . _FSUBJECT . " :</td><td><input type=\"text\" name=\"subject\" size=\"35\" value=\"" . mxEntityQuotes($subject) . "\" />" . $req . "</td></tr>\n"
  . "<tr valign=\"top\"><td>" . _FMESSAGE . " :</td><td><textarea name=\"message\" cols=\"" . (($mxfbcfg['showrtblks']) ? '43': '55') . "\" rows=\"7\">" . htmlspecialchars($message) . "</textarea>" . $req . "<br /><span class=\"tiny\">" . _FMESSAGEEXPLAIN . "</span></td></tr>\n";
  // Allowed to send copy to self?
  if ($mxfbcfg['letreceive'] == "1") {
    echo "<tr valign=\"top\"><td><span class=\"tiny\">" . _FMESSAGERECEIVE . "</span></td><td>
        <input type=\"radio\" name=\"sendcopy\" value=\"1\"" . (empty($sendcopy) ? '' : ' checked="checked"') . " /> " . _YES . "
        <input type=\"radio\" name=\"sendcopy\" value=\"0\"" . (empty($sendcopy) ? ' checked="checked"' : '') . " /> " . _NO . "
        </td></tr>\n";
  }
  if ($captcha_object->get_active()) {
    echo '<tr valign="top"><td></td><td><br />' . $captcha_object->complete() . $req . '</td></tr>';
  }
  echo "</table><br />\n";

  echo "<p class=\"note align-center\">" . sprintf(_IPRECORDED, MX_REMOTE_ADDR) . "</p>\n";
  $uc = load_class("Userconfig");
  $link = $uc->get("agb_agree_link");
  if (mxModuleActive("legal")) {
    echo "<p class=\"highlight align-center\"><a href='".$link."' title='" . _LEGALPP . "'>" . _LEGALPP . "</a></p>\n<br/>";
  }

  echo "<div align='center'><input type=\"submit\" value=\"" . _SEND . "\" />\n";
  echo "</div>\n</form>\n";

  echo "<script type=\"text/javascript\">
    <!--
    function chkFeedbackFormular()
    {
    ";
  if (($numdepts >= 1) && ($mxfbcfg['deptson'] == '1')) {
    echo "if (document.feedbackform.deptemail.value == \"\")
            {
                  alert(\"" . mxHtmlEntityDecode(_ERRORDEPT) . ".\");
                  document.feedbackform.deptemail.focus();
                  return false;
            }";
  }
  echo "
        if (document.feedbackform.fname.value == \"\")
        {
              alert(\"" . mxHtmlEntityDecode(_ERRORNAME) . "\");
              document.feedbackform.fname.focus();
              return false;
        }";
  if ($mxfbcfg['reqlname'] == "1") {
    echo "if (document.feedbackform.lname.value == \"\")
            {
                  alert(\"" . mxHtmlEntityDecode(_ERRORLASTNAME) . "\");
                  document.feedbackform.lname.focus();
                  return false;
            }";
  }
  echo "if (document.feedbackform.email21.value == \"\")
        {
              alert(\"" . mxHtmlEntityDecode(_ERROREMAILADDRESS) . ".\");
              document.feedbackform.email21.focus();
              return false;
        }
        if (document.feedbackform.subject.value == \"\")
        {
              alert(\"" . mxHtmlEntityDecode(_ERRORSUBJECT) . "\");
              document.feedbackform.subject.focus();
              return false;
        }
        if (document.feedbackform.message.value == \"\")
        {
              alert(\"" . mxHtmlEntityDecode(_ERRORMESSAGE) . "\");
              document.feedbackform.message.focus();
              return false;
           }
        return true;
    }
    //-->
    </script>";
  //CloseTable();
}



/**
* die Platzhalter im Mailtext ersetzen
*/
function replace_placeholder($document) {
  global $fname,
  $lname,
  $email,
  $message,
  $row,
  $default_email;
  $today = date(_TIMESTRING);
  $search = array ("{today}",
    "{fname}",
    "{lname}",
    "{uip}",
    "{email}",
    "{message}",
    "{anrede}",
    "{vvname}",
    "{vname}",
    "{department}",
    "{defaultemail}");

  $replace = array ($today,
    $fname,
    $lname,
    MX_REMOTE_ADDR,
    $email,
    $message,
    $row['pp'],
    $row['vvname'],
    $row['vname'],
    $row['dname'],
    $default_email
  );

  $text = str_replace ($search, $replace, $document);
  return $text;
}

function feedback_DeptCount() {
  /**
  * Ansprechpartner Array erstellen
  */
  global $prefix;
  $depts_result = sql_query("SELECT did, dname FROM " . $prefix . "_mxfeedback_depts ORDER BY dname ASC");
  $arraydepts = array();
  while ($depts = sql_fetch_array($depts_result)) {
    $arraydepts[$depts['did']] = $depts['dname'];
  }
  return count($arraydepts);
}


?>