<?php
/**
 * This file is part of
 * pragmaMx - Web Content Management System.
 * Copyright by pragmaMx Developer Team - http://www.pragmamx.org
 *
 * pragmaMx is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * $Revision: 1151 $
 * $Author: PragmaMx $
 * $Date: 2025-06-14 12:53:03 +0200 (Sa, 14. Jun 2025) $
 *
 *
 */

defined('mxMainFileLoaded') or die('access denied');
// rechte Bloecke anzeigen?
// 0 = nein, 1 = ja
$index = 0;

$module_name = basename(__DIR__);
mxGetLangfile($module_name);

$pagetitle = _FRIEND;

if (!mxModuleAllowed('Recommend_Us')) {
    mxErrorScreen('<strong>' . _MODULENOTACTIVE . '</strong><br />');
}

/**
 * das Formular
 */
function RecommendSite($event = array())
{
    global $sitename, $prefix, $module_name;

    if (isset($event['more'])) {
        $tmp = mxSecureValue(unserialize(base64_decode($event['more'])), true);
        if (is_array($tmp)) {
            $event['yname'] = $tmp['yname'];
            $event['ymail'] = $tmp['ymail'];
        }
    }

    if (MX_IS_USER && empty($event['yname']) && empty($event['ymail'])) {
        $uinfo = mxGetUserData();
        $event['yname'] = $uinfo['uname'];
        $event['ymail'] = $uinfo['email'];
    }

    $pid = (isset($_REQUEST['pid'])) ? $_REQUEST['pid'] : 0;
    $result = sql_query("SELECT pid, title FROM " . $prefix . "_pages WHERE pid=" . intval($pid));
    list($event['pid'], $event['title']) = sql_fetch_row($result);
    if (empty($event['pid'])) {
        mxErrorScreen(_NONCLASSCONT);
    }

    include_once("header.php");
    title(_FRIEND);
    if (isset($event['recerror'])) {
        openTableAl();
        echo '<div style="text-align: left;"><h2>' . _REC_ERRORTITLE . '</h2><ul><li>' . implode('</li><li>', $event['recerror']) . '</li></ul></div>';
        closeTableAl();
        echo '<br />';
    }
    OpenTable();
    echo '<p>' . _YOUSENDSTORY . ' \'<b>' . $event['title'] . '</b>\'</p>';
    echo "<form action=\"modules.php?name=" . $GLOBALS['module_name'] . "&amp;file=friend&amp;pid=" . $event['pid'] . "\" method=\"post\" name=\"sendform\">"
     . "<input type=\"hidden\" name=\"name\" value=\"" . $GLOBALS['module_name'] . "\" />"
     . "<input type=\"hidden\" name=\"file\" value=\"friend\" />"
     . "<input type=\"hidden\" name=\"op\" value=\"SendSite\" />"
     . "<input type=\"hidden\" name=\"site\" value=\"" . mx_urltohtml($_SERVER['HTTP_REFERER']) . "\" />"
     . "<input type=\"hidden\" name=\"pid\" value=\"" . $event['pid'] . "\" />"
     . "<table class=\"form\">"
     . "<tr><td>" . _FFRIENDNAME . " </td><td> <input type=\"text\" name=\"fname\" value=\"" . (isset($event['fname']) ? mxEntityQuotes($event['fname']): '') . "\" size=\"35\" /></td></tr>\n"
     . "<tr><td>" . _FFRIENDEMAIL . " </td><td> <input type=\"text\" name=\"fmail\" value=\"" . (isset($event['fmail']) ? mxEntityQuotes($event['fmail']): '') . "\" size=\"35\" /></td></tr>\n"
     . "<tr valign=\"top\"><td>" . _FREMARKS . " </td><td><textarea name=\"remarks\" cols=\"35\" rows=\"5\">" . (isset($event['remarks']) ? mxEntityQuotes(strip_tags($event['remarks'])): '') . "</textarea></td></tr>\n"
     . "<tr><td>" . _FYOURNAME . " </td><td> <input type=\"text\" name=\"yname\" value=\"" . (!empty($event['yname']) ? mxEntityQuotes($event['yname']): '') . "\" size=\"35\" /></td></tr>\n"
     . "<tr><td>" . _FYOUREMAIL . " </td><td> <input type=\"text\" name=\"ymail\" value=\"" . (!empty($event['ymail']) ? mxEntityQuotes($event['ymail']): '') . "\" size=\"35\" /></td></tr>\n";
    // captcha anzeigen
    $captcha_object = load_class('Captcha', 'recommendon');
    if ($captcha_object->get_active()) {
        echo '<tr><td>&nbsp;</td><td><div><br />' . $captcha_object->complete() . '</div></td></tr>' . "\n";
    }
    echo "<tr><td>&nbsp;</td><td  align=\"center\"><br /><input type=\"submit\" name=\"submitcancel\" value=\"" . _SENDCANCEL . "\" title=\"" . _TOCONTENT . "\" />&nbsp;&nbsp;<input type=\"submit\" name=\"submitsend\" value=\"" . _SENDFRIEND . "\" />";
    
    echo "</td></tr></table>"
     . "</form>\n";
    CloseTable();
    include_once('footer.php');
}

/**
 * Die Verarbeitung und Fehlerprüfung
 */
function SendSite()
{
    global $sitename, $prefix, $module_name;

    $event = mxStripSlashes($_POST);
    $pid = (isset($event['pid'])) ? $event['pid'] : 0;

    if (isset($event['submitcancel']) && $pid) {
        mxRedirect('modules.php?name=' . $module_name . '&amp;pid=' . $pid);
    }
    $result = sql_query("SELECT pid, title FROM " . $prefix . "_pages WHERE pid=" . intval($pid));
    list($event['pid'], $event['title']) = sql_fetch_row($result);
    if (empty($event['pid'])) {
        mxErrorScreen(_NONCLASSCONT);
    }
    if (empty($event['yname'])) {
        $event['recerror'][] = _REC_ERRORNAME;
    }

    switch (true) {
        case empty($event['ymail']):
        case !mxCheckEmail($event['ymail']):
            $event['recerror'][] = _REC_ERRORSENDER;
            break;
        case pmx_is_mail_banned($event['ymail']):
            $event['recerror'][] = _REC_ERRORSENDER . ' (' . _MAILISBLOCKED . ')';
    }

    switch (true) {
        case empty($event['fmail']):
        case !mxCheckEmail($event['fmail']):
            $event['recerror'][] = _REC_ERRORRECEIVER;
            break;
        case pmx_is_mail_banned($event['fmail']):
            $event['recerror'][] = _REC_ERRORRECEIVER . ' (' . _MAILISBLOCKED . ')';
    }

    $captcha_object = load_class('Captcha', 'recommendon');
    if (!$captcha_object->check($_POST, 'captcha')) {
        $event['recerror'][] = _CAPTCHAWRONG;
    }

    if (isset($event['recerror'])) {
        RecommendSite($event);
    } else {
        if (MX_IS_USER) {
            $usersession = mxGetUserSession();
        } else {
            $usersession[0] = 0;
        }
        $subject = strip_tags(_INTERESTING . " " . $sitename . ", " . $event['title']);
        $message = _HELLO . " " . $event['fname'] . ",\n\n" . _YOURFRIEND . " " . $event['yname'] . " " . _CONSIDERED . "\n" . _CONURL . ": " . PMX_HOME_URL . "/modules.php?name=" . $module_name . "&amp;pid=" . $event['pid'] . " \n\n" . _YOUCANREAD . " " . $sitename . "\n" . PMX_HOME_URL;
        if (!empty($event['remarks'])) {
            $message .= "\n\n" . $event['yname'] . " " . _FMEANS . ":\n" . $event['remarks'] . "\n\n\n";
        }
        $message = strip_tags($message);
        if (mxMail($event['fmail'], $subject, $message, $event['ymail'], "text", "", $event['yname'])) {
            sql_query("INSERT INTO " . $prefix . "_recommend VALUES (NULL,'" . mxAddSlashesForSQL(strip_tags($event['fname'])) . "','" . $event['fmail'] . "','" . mxAddSlashesForSQL(strip_tags($event['yname'])) . "','" . $event['ymail'] . "','" . $usersession[0] . "','" . mxAddSlashesForSQL(MX_REMOTE_ADDR) . "','" . time() . "','" . mxAddSlashesForSQL(strip_tags($event['site'])) . "')");
        }
        // das ist nur eine Dummy-Weiterleitung um das Aktualisieren der Seite zu verhindern
        $more = array('fname' => $event['fname'],
            'fmail' => $event['fmail'],
            'yname' => $event['yname'],
            'ymail' => $event['ymail'],
            );
        $more = base64_encode(serialize($more));
        mxRedirect('modules.php?name=' . $module_name . '&file=friend&op=SiteSent&pid=' . $event['pid'] . '&more=' . $more, '', 0);
    }
}

/**
 * das ist nur eine Dummy-Weiterleitung um das Aktualisieren der Seite zu verhindern
 */
function SiteSent()
{
    global $module_name, $prefix;
    $pid = (isset($_GET['pid'])) ? $_GET['pid'] : 0;
    $result = sql_query("SELECT pid, title FROM " . $prefix . "_pages WHERE pid=" . intval($pid));
    list($pid, $title) = sql_fetch_row($result);
    if (empty($pid)) {
        mxErrorScreen(_NONCLASSCONT);
    }
    $more = isset($_GET['more']) ? $_GET['more'] : '';
    if ($more) {
        $tmp = mxSecureValue(unserialize(base64_decode($more)), true);
        $fname = $tmp['fname'];
    } else {
        $fname = '?';
    }
    $msg = _FSTORY . ' <strong>' . $title . '</strong> ' . _HASSENT . ' ' . $fname . '... <br /><br />' . _THANKS;
    mxRedirect('modules.php?name=' . $module_name . '&amp;pid=' . $pid, $msg, 5);
}

/**
 * Auswahl der Optionen
 */
$op = (isset($_REQUEST['op'])) ? $_REQUEST['op'] : "";
switch ($op) {
    case 'SendSite':
        SendSite();
        break;

    case 'SiteSent':
        SiteSent();
        break;

    default:
        RecommendSite($_GET);
        break;
}

?>