<?php
/**
 * This file is part of
 * pragmaMx - Web Content Management System.
 * Copyright by pragmaMx Developer Team - http://www.pragmamx.org
 *
 * pragmaMx is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * $Revision: 1151 $
 * $Author: PragmaMx $
 * $Date: 2025-06-14 12:53:03 +0200 (Sa, 14. Jun 2025) $
 *
 *
 * Based on Journey Links Hack
 * Copyright (c) 2000 by James Knickelbein
 * Journey Milwaukee (http://www.journeymilwaukee.com)
 */

defined('mxMainFileLoaded') or die('access denied');

function reportbroken($lid)
{
    global $prefix, $module_name, $pagetitle;
    if (!modCheckAndCleanSubdata($lid)) {
        mxRedirect('modules.php?name=' . $module_name);
    }

    $result = sql_query("SELECT lid, title FROM " . $prefix . "_links_links WHERE lid=" . intval($lid) . " AND cid > 0");
    list($lid, $title) = sql_fetch_row($result);
    // falls fehlerhafte lid uebergeben
    if (empty($lid)) {
        mxErrorScreen('link id ' . intval($lid) . ' not found...');
    }
    // Daten fuer header aufbereiten
    $pagetitle = strip_tags($title . ', ' . _REPORTBROKEN);
    $pagesubmenu = modDetailsTopMenu($lid);
    $captcha_object = load_class('Captcha', 'weblinkson');
    include(PMX_MODULES_DIR . DS . $module_name . '/includes/header.php');
    OpenTable();
    echo '<h4 class="option">' . _REPORTBROKEN . '</h4>';
    echo '
    <form action="modules.php?name=' . $module_name . '&amp;op=view&amp;lid=' . $lid . '" method="post" name="bform" id="bform">
    <input type="hidden" name="name" value="' . $module_name . '" />
    <input type="hidden" name="op" value="reportbrokensave" />
    <input type="hidden" name="lid" value="' . $lid . '" />
    <p>' . _THANKSBROKEN . '<br />' . _SECURITYBROKEN . '</p><br />';
    if ($captcha_object->get_active()) {
        echo '<div>' . $captcha_object->complete() . '<br /><br /></div>
        &nbsp;&nbsp;
        ';
    }
    echo '<input type="submit" value="' . _REPORTBROKEN . '" />
    </form>
    ';

    if ($captcha_object->get_active()) {

        ?>
    <script type="text/javascript">
    /*<![CDATA[*/
        document.bform.captcha.focus();
    /*]]>*/
    </script>
    <?php
    }
    CloseTable();
    include(PMX_MODULES_DIR . DS . $module_name . '/includes/footer.php');
}

function reportbrokensave()
{
    global $prefix, $module_name, $linknotify;

    $lid = (empty($_POST['lid'])) ? 0 : intval($_POST['lid']);
    $result = sql_query("select lid, url from " . $prefix . "_links_links where lid=" . intval($lid) . " AND cid > 0");
    $thisdata = sql_fetch_assoc($result);
    // falls fehlerhafte lid uebergeben
    if (empty($thisdata['lid'])) {
        mxErrorScreen('link id ' . intval($lid) . ' not found...');
        exit;
    }

    /* captcha pruefen */
    $captcha_object = load_class('Captcha', 'weblinkson');
    if (!$captcha_object->check($_POST, 'captcha')) {
        mxRedirect('modules.php?name=' . $module_name . '&amp;op=reportbroken&amp;lid=' . $lid, _CAPTCHAWRONG, 2);
    }

    /* falls Datei existiert, kommentarlos weitermachen... */
    if (!preg_match('#://#', $thisdata['url']) && @is_file($thisdata['url'])) {
        mxRedirect('modules.php?name=' . $module_name . '&amp;op=view&amp;lid=' . $lid, _THANKSFORINFO, 1);
    }

    if (MX_IS_USER) {
        $usersession = mxGetUserSession();
        $modifysubmitter = $usersession[1];
    } else {
        $modifysubmitter = $GLOBALS['anonymous'];
    }
    $qry = "INSERT INTO " . $prefix . "_links_modrequest (lid, modifysubmitter, brokenlink)
            VALUES (
            " . intval($lid) . ",
            '" . mxAddSlashesForSQL($modifysubmitter) . "',
            1)";
    if (sql_query($qry)) {
        // mail an admin senden
        if ($linknotify) {
            $link = PMX_HOME_URL . '/' . adminUrl(PMX_MODULE, 'ListBroken');
            $notify_message = ("-- " . _DUSERREPBROKEN . " --\n" . $GLOBALS['notify_message'] . "\n\n========================================================\n" . $link . "\n\nat: " . mx_strftime(_SHORTDATESTRING . ' H:M', time()) . "\nip/ip:" . MX_REMOTE_ADDR . "\nfrom: " . $modifysubmitter . "\n");
            mxMail($GLOBALS['notify_email'], $GLOBALS['notify_subject'] . ' (' . _MODUNAME . ')', $notify_message, $GLOBALS['notify_from']);
        }
        mxRedirect('modules.php?name=' . $module_name . '&amp;op=view&amp;lid=' . $lid, _THANKSFORINFO . '<br />' . _LOOKTOREQUEST . '<br />', 5);
    } else {
        mxErrorScreen('Database-Error');
    }
}

?>