<?php
/**
 * This file is part of
 * pragmaMx - Web Content Management System.
 * Copyright by pragmaMx Developer Team - http://www.pragmamx.org
 *
 * pragmaMx is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * $Revision: 1151 $
 * $Author: PragmaMx $
 * $Date: 2025-06-14 12:53:03 +0200 (Sa, 14. Jun 2025) $
 *
 *
 * Base on Reviews Addon
 * Copyright (c) 2000 by Jeff Lambert (jeffx@ican.net) http://www.qchc.com
 * More scripts on http://www.jeffx.qchc.com
 */

defined('mxMainFileLoaded') or die('access denied');

$module_name = basename(__DIR__);
mxGetLangfile($module_name);
pmxBase::set("plugins",1);
define('_REVDATEFORMAT', _SHORTDATESTRING . ' ' . _TIMEFORMAT);

require_once(__DIR__ . '/includes/config.php');
require_once(__DIR__ . '/includes/functions.php');

/* Security-Check */
function reviewActionIsAllowed()
{
    global $anonpost;

    if (!MX_IS_USER && !$anonpost && !mxGetAdminPref('radminreviews')) {
        mxErrorScreen(_REVIEWNOANO, _REVIEWERROR);
        exit;
    } else {
        return true;
    }
}

/* Alphabet abhängig von Sprache ermitteln */
function get_alphabet()
{
    $alphabet = array();

    if (!_SPECIALCHARS_ONLY) {
        for ($i = 65; $i <= 90; $i++) {
            $alphabet[] = chr($i);;
        }
    }

    /* Sonderzeichen aus Sprachdatei, aber nur die, die auch als Gross-Zeichen existieren, also nicht das ß */
    include_once(UTF8 . DS . 'str_split.php');
    $uppers = utf8_str_split(utf8_strtoupper(_SPECIALCHARS));
    $lowers = utf8_str_split(utf8_strtolower(_SPECIALCHARS));
    $more = array_unique(array_diff($uppers, $lowers));

    $alphabet = array_merge($alphabet, $more, range(1, 9));
    $alphabet[] = 0;

    return $alphabet;
}

/* Builds the alphabetic sorting-options, index-page */
function alpha()
{
    global $module_name, $anonpost, $prefix;

    if ($GLOBALS['multilingual']) {
        if (strpos($GLOBALS['currentlang'], 'german') === 0) $thislang = "german";
        else $thislang = $GLOBALS["currentlang"];
        $querylang = "WHERE (rlanguage LIKE '$thislang%' OR rlanguage = '')";
    } else {
        $querylang = "";
    }

    $alphabet = get_alphabet();

    $result = sql_query("SELECT DISTINCT UPPER(LEFT( title, 1 )), count(id) FROM `" . $prefix . "_reviews` $querylang GROUP BY left( title, 1 )");
    $letters = array();
    while (list($letter, $count) = sql_fetch_row($result)) {
        $letters[$letter] = $count;
        // verwendete (Sonder)Zeichen ans Alphabet anfügen
        $alphabet[] = $letter;
    }
    $alphabet = array_unique($alphabet);
    $num = count($alphabet) - 1;
    $half = ceil($num / 2);

    echo "<center>[ ";
    $counter = 0;
    foreach ($alphabet as $ltr) {
        if (isset($letters[$ltr])) {
            echo "<a href='modules.php?name=$module_name&amp;rop=$ltr' title='" . $letters[$ltr] . " " . _REVIEWSNAME . "'>$ltr</a>";
        } else {
            echo $ltr;
        }
        if ($counter == $half) {
            echo " ]\n<br />\n[ ";
        } elseif ($counter != $num) {
            echo "&nbsp;|&nbsp;";
        }
        $counter++;
    }
    echo " ]</center><br /><br />\n";

    if (mxGetAdminPref('radminreviews') || MX_IS_USER || $anonpost) {
        echo "<center>[&nbsp;<a href=\"modules.php?name=$module_name&amp;rop=write_review\">" . _WRITEREVIEW . "</a>&nbsp;]</center><br /><br />\n\n";
    }
}

/* Formats score-display */
function display_score($score)
{
    $bad = mxCreateImage('images/td.gif');
    $image = mxCreateImage('images/blue.gif');
    $halfimage = mxCreateImage('images/bluehalf.gif');
    $full = mxCreateImage('images/star.gif');

    if ($score == 10) {
        for ($i = 0; $i < 5; $i++)
        echo $full;
    } elseif ($score % 2) {
        $score -= 1;
        $score /= 2;
        for ($i = 0; $i < $score; $i++)
        echo $image;
        echo $halfimage;
    } elseif ($score && $score != 1) {
        $score /= 2;
        for ($i = 0; $i < $score; $i++)
        echo $image;
    } elseif ($score) {
        echo $halfimage;
    } else {
        echo $bad;
    }
}

/* Displays form to write new reviews */
function write_review()
{
    global $sitename, $prefix, $user_prefix, $currentlang, $module_name, $anonpost, $revimagepath;
    if (MX_IS_USER) {
        $userinfo = mxGetUserData();
        $thisuser = $userinfo['uname'];
    } else {
        $thisuser = $GLOBALS['anonymous'];
    }

    reviewActionIsAllowed();
    if (isset($_POST['text'])) {
        $c_text = $_POST['text'];
    } else {
        $c_text = "";
    }
    $editor = load_class('Textarea', array('name' => 'text', 'value' => $c_text, 'height' => '300', 'pagebreak' => true));

    include_once('header.php');
    OpenTable();

    echo "<fieldset><legend>" . _WRITEREVIEWFOR . " $sitename</legend>
      <form method=\"post\" action=\"modules.php?name=$module_name\">
      <p><b>" . _PRODUCTTITLE . ":</b><br />
      <input type=\"text\" name=\"title\" size=\"60\" maxlength=\"255\" /><br />
      <span class=\"tiny\">" . _NAMEPRODUCT . "</span><br /></p>";
    if ($GLOBALS['multilingual']) {
        echo "<br /><p><b>" . _LANGUAGE . ": </b>"
         . mxLanguageSelect('rlanguage', $currentlang, 'language', 1) . '<br /><br /></p>';
    } else {
        echo "<input type=\"hidden\" name=\"rlanguage\" value=\"\" /><br /><br />";
    }
    echo "<p><b>" . _REVIEW . ":</b><br />" . $editor->getHtml() . "
    <br /><br /></p>
    <p><b>" . _SCORE . "</b>&nbsp;
    <select name=\"score\">
    <option value=\"10\">10</option>
    <option value=\"9\">9</option>
    <option value=\"8\">8</option>
    <option value=\"7\">7</option>
    <option value=\"6\">6</option>
    <option value=\"5\" selected=\"selected\">5</option>
    <option value=\"4\">4</option>
    <option value=\"3\">3</option>
    <option value=\"2\">2</option>
    <option value=\"1\">1</option>
    <option value=\"0\">0</option>
    </select><br />
    <span class=\"tiny\">" . _SELECTSCORE . "</span><br /><br /></p>
    <p><b>" . _RELATEDLINK . ":</b><br />
    <input type=\"text\" name=\"url\" size=\"60\" maxlength=\"255\" value=\"\" /><br />
    <span class=\"tiny\">" . _PRODUCTSITE . "</span><br /><br /></p>
    <p><b>" . _LINKTITLE . ":</b><br />
    <input type=\"text\" name=\"url_title\" size=\"60\" maxlength=\"255\" /><br />
    <span class=\"tiny\">" . _LINKTITLEREQ . "</span><br /><br /></p>
    ";
    if (mxGetAdminPref('radminreviews')) {
        echo "
        <p><b>" . _COVERIMAGE . ":</b><br />
        " . revImageBrowse() . "<br />
        <span class=\"tiny\">" . sprintf(_RIMAGEFILEREQ, $revimagepath) . "</span>
        <br /><br /></p>
        ";
    }
    echo "<br /><br /><p>
    <input type=\"hidden\" name=\"reviewer\" value=\"$thisuser\" />
    <input type=\"hidden\" name=\"rop\" value=\"preview_review\" />
    <input type=\"hidden\" name=\"name\" value=\"$module_name\" />
    <input type=\"submit\" value=\"" . _PREVIEW . "\" />
    <input type=\"button\" onclick=\"history.go(-1)\" value=\"" . _CANCEL . "\" /></p>
    <p style=\"font-style:italic;\">" . _CHECKINFO . "</p>
    </form></fieldset>";
    CloseTable();
    include_once("footer.php");
}

/* Displays review-preview before committing it */
function preview_review($date, $title, $text, $reviewer, $score, $cover, $url, $url_title, $hits, $id, $rlanguage)
{
    global $sitename, $module_name, $anonpost, $revimagepath;

    $error = (empty($error)) ? "" : $error;
    $reverrormsg = (empty($reverrormsg)) ? "" : $reverrormsg;

    reviewActionIsAllowed();

    $title = strip_tags(mxPrepareToDisplay(mxStripSlashes($title)));
    $text = mxPrepareToDisplay(mxStripSlashes($text));

    $reviewer = mxPrepareToDisplay(mxStripSlashes($reviewer));
    $cover = mxPrepareToDisplay(mxStripSlashes($cover));
    $url = mxPrepareToDisplay(mxStripSlashes($url));
    $url_title = mxPrepareToDisplay(mxStripSlashes($url_title));

    if (empty($title)) {
        $error = true;
        $reverrormsg = _INVALIDTITLE . '<br />';
    }
    if (empty($text)) {
        $error = true;
        $reverrormsg .= _INVALIDTEXT . '<br />';
    }
    if (($score < 0) || ($score > 10)) {
        $error = true;
        $reverrormsg .= _INVALIDSCORE . '<br />';
    }
    if (($hits < 0) && !empty($id)) {
        $error = true;
        $reverrormsg .= _INVALIDHITS . '<br />';
    }
    if (empty($reviewer)) {
        $error = true;
        $reverrormsg .= _CHECKNAME . '<br />';
    }
    if ((!empty($url_title) && empty($url)) || (empty($url_title) && !empty($url))) {
        $error = true;
        $reverrormsg .= _INVALIDLINK . '<br />';
    } else if (!empty($url) && !(preg_match('#(^http[s]*:[/]+)(.*)#i', $url))) {
        $url = "http://" . $url;
    }

    $editor = load_class('Textarea', array('name' => 'text', 'value' => $text, 'height' => '300', 'pagebreak' => true));

    $titlezeile = _WRITEREVIEWFOR . ' ' . $sitename;

    include_once('header.php');
    title($titlezeile); // angepasst an Layout
    OpenTable();
    echo (!$error) ? "<form method=\"post\" action=\"modules.php?name=$module_name\">" : "";
    if ($error) { // Fehler ausgeben - angepasst an Layout
        OpenTableAl();
        echo '<h3 style="text-align: center;">' . $reverrormsg . '</h3>';
        CloseTableAl();
    } else {
        if (empty($date)) $date = time();
        $fdate = mx_strftime(_REVDATEFORMAT, $date);
        echo "<table width=\"100%\"><tr><td colspan=\"2\">";
        echo "<p><font class=\"title\"><i><b>" . $title . "</b></i></font><br /><br />";
        if ($reviewer == $GLOBALS['anonymous']) {
            echo _POSTEDBY . " $reviewer " . _ON . " $fdate<br />";
        } else {
            echo _POSTEDBY . ' ' . mxCreateUserprofileLink($reviewer) . ' ' . _ON . ' ' . $fdate . '<br />';
        }
        echo "<b>" . _SCORE . "</b> ";
        display_score($score);
        echo "&nbsp;&nbsp;($score " . _REVIEWOF . " 10)";

        if ($GLOBALS['multilingual']) {
            echo "<br /><b>" . _LANGUAGE . ":</b> $rlanguage";
        }
        if (!empty($url)) {
            echo "<br /><b>" . _RELATEDLINK . ":</b> <a href=\"$url\" target=\"new\">$url_title</a>";
        }
        if (!empty($id)) {
            echo "<br /><b>" . _REVIEWID . ":</b> $id<br />";
            echo "<b>" . _HITS . ":</b> $hits<br />";
        }
        echo "<hr noshade size=1>";
        if ($cover != "") {
            echo mxCreateImage($revimagepath . $cover, '', 1, 'style="margin:10px;max-width:90%"');
        }
        echo pmx_split_pages($text, 'preview');
        echo "</td></tr></table>
          <hr noshade size=1>
          <p><i>" . _LOOKSRIGHT . "</i><br /><br />
          <input type=\"hidden\" name=\"id\" value=$id />
          <input type=\"hidden\" name=\"hits\" value=\"$hits\" />
          <input type=\"hidden\" name=\"rop\" value=\"send_review\" />
          <input type=\"hidden\" name=\"date\" value=\"$date\" />
          <input type=\"hidden\" name=\"title\" value=\"" . rawurlencode($title) . "\" />
          <input type=\"hidden\" name=\"text\" value=\"" . rawurlencode($text) . "\" />
          <input type=\"hidden\" name=\"reviewer\" value=\"$reviewer\" />
          <input type=\"hidden\" name=\"score\" value=\"$score\" />
          <input type=\"hidden\" name=\"url\" value=\"$url\" />
          <input type=\"hidden\" name=\"url_title\" value=\"" . rawurlencode($url_title) . "\" />
          <input type=\"hidden\" name=\"cover\" value=\"$cover\" />
          <input type=\"hidden\" name=\"rlanguage\" value=\"$rlanguage\" />";
        $captcha_object = load_class('Captcha', 'reviewson');
        if ($captcha_object->get_active()) {
            echo '<br /><br />' . $captcha_object->show_complete() . '<br /><br />';
     
        }
        echo "<input type=\"submit\" name=\"rop\" value=\"" . _YES . "\" />";

        echo "</form>";
        if (mxGetAdminPref('radminreviews')) {
            echo "<br /><br /><b>" . _NOTE . "</b> " . _ADMINLOGGED . ".";
        }
    }
    // Auf jeden Fall Kann der User das Bericht bearbeiten
    // Formular ausgeben und füllen
    echo '<form method="post" action="modules.php?name=' . $module_name . '">';
    echo '<p class="bgcolor2" style="font-style:italic;padding:3px;">' . _REVIEWMOD . '</p>';
    // Produktname
    echo '<div>' . _PRODUCTTITLE . '</div>';
    echo '<input type="text" name="title" size="60" maxlength="255" value="' . $title . '" />';
    echo '<br /><span style="font-style:italic;">' . _NAMEPRODUCT . '</span>';
    // Sprache
    if ($GLOBALS['multilingual']) {
        echo '<p><b>' . _LANGUAGE . ': </b>'
         . mxLanguageSelect('rlanguage', $rlanguage, 'language', 1) . '</p>';
    } else {
        echo '<input type="hidden" name="rlanguage" value="' . $rlanguage . '" />';
    }
    // Beschreibung
    echo "<b>" . _REVIEW . ":</b><br />";
    $editor->show();
    // Wertung des Produkts
    echo '<p><span style="font-weight:bold;">' . _SCORE . '</span> <select name="score">';
    for ($i = 10; $i >= 0; $i--) {
        echo '<option value="' . $i . '"';
        if ($i == $score) {
            echo ' selected="selected" class="current"';
        }
        echo '>' . $i . '</option>';
    }
    echo '</select> <span class="tiny">' . _SELECTSCORE . '</span></p>';
    // Zugehöriges Link
    echo '<div style="font-weight:bold;">' . _RELATEDLINK . ':</div>';
    echo '<input type="text" name="url" size="60" maxlength="255" value="' . $url . '" />';
    echo '<br /><span class="tiny">' . _PRODUCTSITE . '</span>';
    // Link Bezeichnung
    echo '<p><span style="font-weight:bold;">' . _LINKTITLE . ':</span><br />';
    echo '<input type="text" name="url_title" size="60" maxlength="255" value="' . $url_title . '" />';
    echo '<br /><span class="tiny">' . _LINKTITLEREQ . '</span></p>';
    // Cover Bild
    if (mxGetAdminPref('radminreviews')) {
        echo '<div style="font-weight:bold;">' . _COVERIMAGE . '</div>';
        echo revImageBrowse($cover);
        echo '<br /><span class="tiny">' . sprintf(_RIMAGEFILEREQ, $revimagepath) . '</span>';
    }
    // Informant
    echo '<input type="hidden" name="reviewer" value="' . $reviewer . '" />';
    // Submit zu Preview
    echo '<input type="hidden" name="rop" value="preview_review" />
        <input type="hidden" name="name" value="' . $module_name . '" />
        <input type="submit" value="' . _PREVIEW . '" />';
    // Bitte überprüfen Angaben
    echo '<p style="font-style:italic;">' . _CHECKINFO . '</p>';
    echo "</form>";
    CloseTable();
    include_once("footer.php");
}

/* Insert new review or changes into the database */
function send_review($date, $title, $text, $reviewer, $score, $cover, $url, $url_title, $hits, $id, $rlanguage)
{
    global $prefix, $module_name, $anonpost, $revallowedit, $revautoactivate;

    reviewActionIsAllowed();

    if (MX_IS_USER) {
        $userinfo = mxGetUserData();
        $thisuser = $userinfo['uname'];
    } else {
        $thisuser = ''; #$GLOBALS['anonymous'];
    }

    $captcha_object = load_class('Captcha', 'reviewson');
    if (!$captcha_object->check($_POST, 'captcha')) {
        include("header.php");
        OpenTable();
        echo "<center><b>" . _CAPTCHAWRONG . "</b><br /><br />" . _GOBACK . "</center>";
        CloseTable();
        include("footer.php");
        exit;
    }
    // Prepare SQL-Insert
    if (strstr($text, PMX_PAGE_DELIMITER)) {
        $text = str_replace(PMX_PAGE_DELIMITER, htmlspecialchars(PMX_PAGE_DELIMITER), $text);
    }
    $title = trim(mxAddSlashesForSQL(rawurldecode($title)));
    $text = trim(mxAddSlashesForSQL(rawurldecode($text)));
    // ob dieses Pagebrake sein muss, muss man noch gucken
    if (strstr($text, htmlspecialchars(PMX_PAGE_DELIMITER))) {
        $text = str_replace(htmlspecialchars(PMX_PAGE_DELIMITER), PMX_PAGE_DELIMITER, $text);
    }
    $reviewer = mxAddSlashesForSQL($reviewer);
    $cover = mxAddSlashesForSQL($cover);
    $url = mxAddSlashesForSQL(mx_urltohtml($url));
    $url_title = mxAddSlashesForSQL(rawurldecode($url_title));
    $date = mxAddSlashesForSQL($date);
    $score = floatval($score);
    $rlanguage = mxAddSlashesForSQL($rlanguage);

    switch (true) {
        case empty($id) && mxGetAdminPref('radminreviews'):
        case empty($id) && $revautoactivate:
            // Admin-Reviews sofort freischalten
            sql_query("INSERT INTO " . $prefix . "_reviews
              SET `date`='$date',
                `title`='$title',
                `text`='$text',
                `reviewer`='$reviewer',
                `score`='$score',
                `cover`='$cover',
                `url`='$url',
                `url_title`='$url_title',
                `rlanguage`='$rlanguage',
                `active`=1");
            $message = _ISAVAILABLE;
            break;
        case !empty($id) && mxGetAdminPref('radminreviews'):
        case !empty($id) && MX_IS_USER && ($reviewer == $thisuser) && $revallowedit:
            $active = intval(mxGetAdminPref('radminreviews') || $revautoactivate);
            // Admin-Änderungen übernehmen
            // User-Änderungen, je nach Einstellung aktivieren
            sql_query("UPDATE " . $prefix . "_reviews
              SET title='$title',
                text='$text',
                reviewer='$reviewer',
                score='$score',
                cover='$cover',
                url='$url',
                url_title='$url_title',
                hits='$hits',
                rlanguage='$rlanguage',
                `active`=$active
              WHERE id = " . intval($id));
            $message = ($active) ? _ISAVAILABLE : _EDITORWILLLOOK;;
            break;
        default:
            // sonst in die Freischalt-Liste eintragen
            sql_query("INSERT INTO " . $prefix . "_reviews
              SET date='$date',
                title='$title',
                text='$text',
                reviewer='$reviewer',
                score='$score',
                url='$url',
                url_title='$url_title',
                rlanguage='$rlanguage',
                `active`=0");
            $message = _EDITORWILLLOOK;
            break;
    }

    $message .= '<p><br />' . _RTHANKS;
    if (empty($id)) {
        $message .= ", $reviewer.";
    } else {
        $message .= " (" . _MODIFICATION . ').';
    }
    $message .= '</p>';

    return mxRedirect("modules.php?name=$module_name", $message);
}

/* Module index-page */
function reviews_index()
{
    global $prefix, $module_name, $anonpost;

    if ($GLOBALS["multilingual"] == 1) {
        if (strpos($GLOBALS['currentlang'], 'german') === 0) $thislang = "german";
        else $thislang = $GLOBALS["currentlang"];
        $querylang = "AND (rlanguage LIKE '$thislang%' OR rlanguage = '')";
    } else {
        $querylang = "";
    }

    include_once('header.php');
    OpenTable();
	echo "<h2>"._RWELCOME."</h2>";	//<font class=\"title\">" . _RWELCOME . "</font>
    echo "<table width=\"95%\" cellpadding=\"2\" cellspacing=\"4\" align=\"center\">
      <tr><td colspan=\"2\"><center></center><br /><br />";
    alpha();
    echo "</td></tr>";
    echo "<tr><td width=\"50%\" class=\"bgcolor2\"><b>" . _TEN_MOSTPOP . "</b></td>";
    echo "<td width=\"50%\" class=\"bgcolor2\"><b>" . _TEN_MOSTREC . "</b></td></tr>";
    $result_pop = sql_query("select id, title, hits from " . $prefix . "_reviews WHERE active='1' $querylang order by hits DESC limit 10");
    $result_rec = sql_query("select id, title, date, hits from " . $prefix . "_reviews WHERE active='1' $querylang order by date DESC limit 10");
    $y = 1;
    for ($x = 0; $x < 10; $x++) {
		$title="";
		$hits=0;
		$id=0;
		$link="";
        if ($x < sql_num_rows($result_pop)) {
			$myrow = sql_fetch_assoc($result_pop);
			//mxDebugFuncVars($myrow);
			$id = $myrow["id"];
			$title = mxPrepareToDisplay($myrow["title"]);
			$hits = $myrow["hits"];
			$link="<a href=\"modules.php?name=$module_name&amp;rop=showcontent&amp;id=$id\">" . strip_tags($title) . "</a>";
		}
		echo "<tr><td width=\"50%\" class=\"bgcolor1\">$y) ".$link."</td>";
		$link="";
		$title="";
		$hits=0;       
	   if ($x < sql_num_rows($result_rec)) {
			$myrow = sql_fetch_assoc($result_rec);
			$id = $myrow["id"];
			$title = mxPrepareToDisplay($myrow["title"]);
			$hits = $myrow["hits"];
			$link="<a href=\"modules.php?name=$module_name&amp;rop=showcontent&amp;id=$id\">" . strip_tags($title) . "</a>";
		}
		echo "<td width=\"50%\" class=\"bgcolor1\">$y) ".$link."</td></tr>";
        $y++;
    }
    echo "<tr><td colspan=\"2\"><br /></td></tr>";
    $result = sql_query("SELECT * FROM " . $prefix . "_reviews WHERE active='1' $querylang");
    $numresults = sql_num_rows($result);
    echo "<tr><td colspan=\"2\"><br /><center>" . _REVTHEREARE . " $numresults " . _REVIEWSINDB . "<br /><br />
        " . _REVIEWINTRO . "<br /><br /></center></td></tr></table>";

    CloseTable();
    include_once("footer.php");
}

/* List reviews fitting to sorting-letter or number */
function reviews($letter)
{
    global $sitename, $prefix, $module_name;

    $letter = strtoupper($letter[0]);

    $listorders = array('ASC', 'DESC', 'asc', 'desc');
    $order = (empty($_GET['order']) || !in_array($_GET['order'], $listorders)) ? $listorders[0] : $_GET['order'];

    $listfields = array('title', 'reviewer', 'score', 'hits');
    $field = (empty($_GET['field']) || !in_array($_GET['field'], $listfields)) ? $listfields[0] : $_GET['field'];

    if ($GLOBALS['multilingual']) {
        if (strpos($GLOBALS['currentlang'], 'german') === 0) $thislang = "german";
        else $thislang = $GLOBALS["currentlang"];
        $querylang = "AND (rlanguage LIKE '$thislang%' OR rlanguage = '')";
    } else {
        $querylang = "";
    }

    $result = sql_query("SELECT id, title, hits, reviewer, score FROM " . $prefix . "_reviews WHERE UPPER(title) LIKE '" . $letter . "%' AND active='1' $querylang ORDER by " . $field . " " . $order);
    $numresults = sql_num_rows($result);

    include_once('header.php');

    OpenTable();

    echo "<h2>" . _REVIEWSNAME . "<h2><br /><br />";
    echo "<i>" . _REVIEWSLETTER . " \"<b>$letter</b>\"</i><br /><br />";

    if ($numresults == 0) {
        echo '<i><b>' . _NOREVIEWS . ' "' . $letter . '"</b></i><br /><br />';
    } elseif ($numresults > 0) {
        echo '
        <table width="100%" cellpadding="2" cellspacing="4">
          <tr>
            <td width="50%" class="bgcolor2">
              <p align="left"><a href="modules.php?name=' . $module_name . '&amp;rop=' . $letter . '&amp;field=title&amp;order=ASC">' . mxCreateImage('images/up.gif', _SORTASC) . '</a> <b>' . _PRODUCTTITLE . '</b> <a href="modules.php?name=' . $module_name . '&amp;rop=' . $letter . '&amp;field=title&amp;order=DESC">' . mxCreateImage('images/down.gif', _SORTDESC) . '</a></p>
            </td>
            <td width="18%" class="bgcolor2">
              <p align="center"><a href="modules.php?name=' . $module_name . '&amp;rop=' . $letter . '&amp;field=reviewer&amp;order=ASC">' . mxCreateImage('images/up.gif', _SORTASC) . '</a> <b>' . _REVIEWER . '</b> <a href="modules.php?name=' . $module_name . '&amp;rop=' . $letter . '&amp;field=reviewer&amp;order=DESC">' . mxCreateImage('images/down.gif', _SORTDESC) . '</a></p>
            </td>
            <td width="18%" class="bgcolor2">
              <p align="center"><a href="modules.php?name=' . $module_name . '&amp;rop=' . $letter . '&amp;field=score&amp;order=ASC">' . mxCreateImage('images/up.gif', _SORTASC) . '</a> <b>' . _SCORE . '</b> <a href="modules.php?name=' . $module_name . '&amp;rop=' . $letter . '&amp;field=score&amp;order=DESC">' . mxCreateImage('images/down.gif', _SORTDESC) . '</a></p>
            </td>
            <td width="14%" class="bgcolor2">
              <p align="center"><a href="modules.php?name=' . $module_name . '&amp;rop=' . $letter . '&amp;field=hits&amp;order=ASC">' . mxCreateImage('images/up.gif', _SORTASC) . '</a> <b>' . _HITS . '</b> <a href="modules.php?name=' . $module_name . '&amp;rop=' . $letter . '&amp;field=hits&amp;order=DESC">' . mxCreateImage('images/down.gif', _SORTDESC) . '</a></p>
            </td>
          </tr>';
        while ($myrow = sql_fetch_array($result)) {
            $title = mxPrepareToDisplay($myrow["title"]);
            $id = $myrow["id"];
            $reviewer = $myrow["reviewer"];
            $score = $myrow["score"];
            $hits = $myrow["hits"];
            echo "<tr>
            <td width=\"50%\" class=\"bgcolor1\"><a href=\"modules.php?name=$module_name&amp;rop=showcontent&amp;id=$id\">" . strip_tags($title) . "</a></td>
            <td width=\"18%\" class=\"bgcolor1\">";
            if ($reviewer != "")
                echo "<center>$reviewer</center>";
            echo "</td><td width=\"18%\" class=\"bgcolor1\"><center>";
            display_score($score);
            echo "</center></td><td width=\"14%\" class=\"bgcolor1\"><center>$hits</center></td>
          </tr>";
        }
        echo "</table>";
        echo "<br />$numresults " . _TOTALREVIEWS . '<br /><br />';
    }
    echo "[&nbsp;<a href=\"modules.php?name=$module_name\">" . _RETURN2MAIN . "</a>&nbsp;]";

    CloseTable();
    include_once("footer.php");
}

/* Display form to write review-comment */
function postcomment($id)
{
    global $module_name, $anonpost;
    if (MX_IS_USER) {
        $userinfo = mxGetUserData();
        $thisuser = $userinfo['uname'];
    } else {
        $thisuser = $GLOBALS['anonymous'];
    }

    reviewActionIsAllowed();

    $editor = load_class('Textarea', array('name' => 'comments', 'mode' => 'mini', 'height' => '200'));
    $captcha_object = load_class('Captcha', 'commentson');

    $title = revGetReviewTitle($id);
    include_once("header.php");
    OpenTable();

    echo "<center><font class=option><b>" . _REVIEWCOMMENT . " $title</b><br /><br /></font></center>";
    echo "<form action='modules.php?name=$module_name' method='post'>";
    if (!MX_IS_USER) {
        echo "<b>" . _YOURNICK . "</b> " . $GLOBALS['anonymous'] . " [ " . _RCREATEACCOUNT . " ]<br /><br />
      <input type=\"hidden\" name=\"xanonpost\" value=\"true\" />";
    } else {
        echo "<input type=\"hidden\" name=\"xanonpost\" value=\"0\" />";
        if ($anonpost) {
            echo "<input type='checkbox' name='xanonpost' value='1' /> " . _POSTANON . '<br /><br />';
        }
    }
    echo "
      <input type='hidden' name='uname' value='$thisuser' />
      <input type='hidden' name='id' value='$id' />
      <input type='hidden' name='name' value='$module_name' />
      <input type='hidden' name='rop' value='savecomment' />
      <b>" . _SELECTSCORE . ":</b>&nbsp;
      <select name=\"score\">
      <option value=\"10\">10</option>
      <option value=\"9\">9</option>
      <option value=\"8\">8</option>
      <option value=\"7\">7</option>
      <option value=\"6\">6</option>
      <option value=\"5\" selected=\"selected\">5</option>
      <option value=\"4\">4</option>
      <option value=\"3\">3</option>
      <option value=\"2\">2</option>
      <option value=\"1\">1</option>
      <option value=\"0\">0</option>
      </select><br /><br />
      <b>" . _YOURCOMMENT . "</b><br />" . $editor->getHtml() . "<br />";

    if ($captcha_object->get_active()) {
        echo '<br /><br />' . $captcha_object->show_complete() . '<br /><br />';
    }
    echo "<input type=\"submit\" value=\"" . _REVIEWSEND . "\" />&nbsp;&nbsp;<input type=\"button\" onclick=\"history.go(-1)\" value=\"" . _CANCEL . "\" />&nbsp;&nbsp;";
 
    echo "</form>";
    CloseTable();
    include_once("footer.php");
}

/* Save review-comment into the database */
function savecomment($xanonpost, $uname, $id, $score, $comments)
{
    global $prefix, $module_name, $anonpost;

    /* captcha pruefen, nicht im Adminmodus */
    $captcha_object = load_class('Captcha', 'commentson');
    if (!$captcha_object->check($_POST, 'captcha')) {
        include("header.php");
        OpenTable();
        echo "<center><b>" . _CAPTCHAWRONG . "</b><br /><br />" . _GOBACK . "</center>";
        CloseTable();
        include("footer.php");
        exit;
    }
    if ($xanonpost && $anonpost) {
        $uname = $GLOBALS['anonymous'];
    }

    if (empty($comments)) {
        mxErrorScreen(_INVALIDTEXT, _REVIEWERROR);
        exit;
    } elseif (reviewActionIsAllowed()) {
        $ok = sql_query("insert into " . $prefix . "_reviews_comments SET rid='" . intval($id) . "', username='" . mxAddSlashesForSQL($uname) . "', date='" . time() . "', comments='" . mxAddSlashesForSQL($comments) . "', score='" . intval($score) . "'");

        /* Notitfy comment by stefvar */
        if ($ok && !empty($GLOBALS['notifycomment'])) {
            $message = _HELLO . ",\n" . sprintf(''
                 . _COMMENTSNOTIFY, $GLOBALS['sitename']) . "\n\n"
             . "========================================================\n"
             . $uname . " " . _WRITES . ": (" . $score . ")\n\n"
             . $comments . "\n\n"
             . "========================================================\n"
             . PMX_HOME_URL . "/modules.php?name=$module_name&rop=showcontent&id=$id\n\n" ;
            mxMail($GLOBALS['notify_email'], $GLOBALS['notify_subject'], $message, $GLOBALS['notify_from']);
        }

        mxRedirect("modules.php?name=$module_name&amp;rop=showcontent&amp;id=$id");
    }
}

/* Sub-function, list all comments of a review */
function r_comments($id, $title)
{
    global $prefix, $module_name, $revcommentssort;
    $title = _REVIEWRE . $title;
    $result = sql_query("select cid, username, date, comments, score from " . $prefix . "_reviews_comments where rid='" . intval($id) . "' ORDER BY date $revcommentssort");
    while (list($cid, $uname, $date, $comments, $score) = sql_fetch_row($result)) {
        OpenTable();
        $date = mx_strftime(_REVDATEFORMAT, $date);
        echo "
      <b>" . strip_tags($title) . "</b><br />";
        if ($uname == $GLOBALS['anonymous']) {
            echo _POSTEDBY . " $uname " . _ON . " $date<br />";
        } else {
            echo _POSTEDBY . ' ' . mxCreateUserprofileLink($uname) . ' ' . _ON . ' ' . $date . '<br />';
        }
        echo _MYSCORE . " ";
        display_score($score);
        echo "&nbsp;&nbsp;($score " . _REVIEWOF . " 10)";
        if (mxGetAdminPref('radminreviews')) {
            echo "<br /><b>" . _ADMIN . "</b> [&nbsp;<a href=\"modules.php?name=$module_name&amp;rop=del_comment&amp;cid=$cid&amp;id=$id\">" . _DELETE . "</a>&nbsp;]<hr noshade size=1>";
        } else {
            echo "<hr noshade size=1>";
        }
        $comments = mxNL2BR(mxPrepareToDisplay($comments));
        echo $comments;
        CloseTable();
        echo '<br />';
    }
}

/* Display review with all comments, multipage if needed */
function showcontent($id, $page)
{
    global $uimages, $prefix, $module_name, $anonpost, $revallowemail, $revallowedit, $pagetitle, $revimagepath;
    if (MX_IS_USER) {
        $userinfo = mxGetUserData();
        $thisuser = $userinfo['uname'];
    } else {
        $thisuser = $GLOBALS['anonymous'];
    }

    $result = sql_query("SELECT * FROM " . $prefix . "_reviews WHERE id=" . intval($id));
    $myrow = sql_fetch_array($result);
    if (!$myrow) {
        return mxErrorScreen(_REVNOTFOUND);
    }

    $id = $myrow["id"];
    $date = mx_strftime(_REVDATEFORMAT, $myrow["date"]);
    $orgtitle = $myrow["title"];
    $title = mxPrepareToDisplay(strip_tags($orgtitle));
    $text = $myrow["text"];
    $cover = $myrow["cover"];
    $reviewer = $myrow["reviewer"];
    $hits = $myrow["hits"];
    $url = mxPrepareToDisplay($myrow["url"]);
    $url_title = mxPrepareToDisplay($myrow["url_title"]);
    $score = $myrow["score"];
    $rlanguage = $myrow["rlanguage"];
    $contentpages = pmx_split_pages($text);
    $pageno = count($contentpages);
    if (empty($page) || $page < 1)
        $page = 1;
    if ($page > $pageno)
        $page = $pageno;
    $arrayelement = (int)$page-1;

    if ($page === 1) {
        sql_query("UPDATE " . $prefix . "_reviews SET hits=hits+1 WHERE id=" . intval($id));
    }

    $pagetitle = _REVIEW . ': ' . $title . (($page < 2) ? '' : ', ' . _PAGE . " $page");
    include_once('header.php');
    OpenTable();

    echo "<h2>" . $title . "</h2><br />";
    if ($reviewer == $GLOBALS['anonymous'])
        echo _POSTEDBY . " $reviewer " . _ON . " $date<br />";
    else
        echo _POSTEDBY . ' ' . mxCreateUserprofileLink($reviewer) . ' ' . _ON . ' ' . $date . '<br />';
    echo "<b>" . _SCORE . "</b> ";
    display_score($score);
    echo "&nbsp;&nbsp;($score " . _REVIEWOF . " 10)";
    if (!empty($url))
        echo "<br /><b>" . _RELATEDLINK . ":</b> <a href=\"$url\" target=new>$url_title</a>";
    echo "<br /><b>" . _HITS . ":</b> $hits";
    echo "<br /><b>" . _LANGUAGE . ":</b> $rlanguage";
    if ($pageno > 1)
        echo "<br /><b>" . _PAGE . ":</b> $page/$pageno<br />";
    if (mxGetAdminPref('radminreviews'))
        echo "<br /><b>" . _ADMIN . "</b> [&nbsp;<a href=\"modules.php?name=$module_name&amp;rop=mod_review&amp;id=$id\">" . _EDIT . "</a> | <a href=\"modules.php?name=$module_name&amp;rop=del_review&amp;id_del=$id\">" . _DELETE . "</a>&nbsp;]<br />";
    if (!mxGetAdminPref('radminreviews') && MX_IS_USER && $reviewer == $thisuser && $revallowedit)
        echo "<br /><b>" . _REVIEWER . "</b> [&nbsp;<a href=\"modules.php?name=$module_name&amp;rop=mod_review&amp;id=$id\">" . _EDIT . "</a>&nbsp;]<br />";
    echo '<hr noshade="noshade" size="1" />';
    if (!empty($cover))
        echo mxCreateImage($revimagepath . $cover, '', 1, 'align="right" vspace="2"');
    // echo mxNL2BR(mxPrepareToDisplay($contentpages[$arrayelement])) . "<p>";
    echo mxPrepareToDisplay($contentpages[$arrayelement]) . '<br /><br />';

    $next_page = "";
    if ($page >= $pageno) {
        $next_page = "";
    } else {
        $next_pagenumber = $page + 1;
        if ($page != 1)
            $next_page .= mxCreateImage('images/blackpixel.gif', '', 0, 'width="10" height="2"') . '&nbsp;&nbsp;&nbsp;&nbsp;';
        $next_page .= '<a href="modules.php?name=' . $module_name . '&amp;rop=showcontent&amp;id=' . $id . '&amp;page=' . $next_pagenumber . '">' . _NEXT . ' (' . $next_pagenumber . '/' . $pageno . ')</a> <a href="modules.php?name=' . $module_name . '&amp;rop=showcontent&amp;id=' . $id . '&amp;page=' . $next_pagenumber . '">' . mxCreateImage('images/next.png', _NEXT) . '</a>';
    }

    if ($page <= 1) {
        $previous_page = "";
    } else {
        $previous_pagenumber = $page - 1;
        $previous_page = '<a href="modules.php?name=' . $module_name . '&amp;rop=showcontent&amp;id=' . $id . '&amp;page=' . $previous_pagenumber . '">' . mxCreateImage('images/previous.png', _PREVIOUS) . '</a> <a href="modules.php?name=' . $module_name . '&amp;rop=showcontent&amp;id=' . $id . '&amp;page=' . $previous_pagenumber . '">' . _PREVIOUS . ' (' . $previous_pagenumber . '/' . $pageno . ')</a>';
    }

    echo "<center>$previous_page &nbsp;&nbsp; $next_page<br /><br />";
    echo "[&nbsp;";
    if ($revallowemail)
        echo "<a href=\"modules.php?name=$module_name&amp;rop=premail_review&amp;id=$id\">" . _REVIEWFWD . "</a> | ";
    echo "<a href=\"modules.php?name=$module_name\">" . _RBACK . "</a>";
    if (mxGetAdminPref('radminreviews') || MX_IS_USER || $anonpost)
        echo " | <a href=\"modules.php?name=$module_name&amp;rop=postcomment&amp;id=$id\">" . _REPLYMAIN . "</a>";
    echo "&nbsp;]</center>";

    CloseTable();
    if ($page == 1 || empty($page)) {
        echo '<br />';
        r_comments($id, $title);
    }
    include_once("footer.php");
}

/* Edit review, only allowed by admin or reviewer himself */
function mod_review($id)
{
    global $prefix, $module_name, $revallowedit, $revimagepath;

    if (MX_IS_USER) {
        $userinfo = mxGetUserData();
        $thisuser = $userinfo['uname'];
    } else {
        $thisuser = $GLOBALS['anonymous'];
    }

    $result = sql_query("select * from " . $prefix . "_reviews where id = " . intval($id));
    if ($myrow = sql_fetch_array($result)) {
        $id = $myrow["id"];
        $date = $myrow["date"];
        $title = mxPrepareToDisplay($myrow["title"]);
        $text = mxPrepareToDisplay($myrow["text"]);
        $cover = mxPrepareToDisplay($myrow["cover"]);
        $reviewer = mxPrepareToDisplay($myrow["reviewer"]);
        $hits = $myrow["hits"];
        $url = mxPrepareToDisplay($myrow["url"]);
        $url_title = mxPrepareToDisplay($myrow["url_title"]);
        $score = $myrow["score"];
        $rlanguage = mxPrepareToDisplay($myrow["rlanguage"]);
    }

    if (!mxGetAdminPref('radminreviews') && (!MX_IS_USER || $thisuser != $reviewer || !$revallowedit)) {
        mxErrorScreen(_REVIEWNORIGHTS, _REVIEWERROR);
        exit;
    }

    if ($reviewer == $GLOBALS['anonymous']) {
        $author = _POSTEDBY . " $reviewer " . _ON . " " . mx_strftime(_REVDATEFORMAT, $date) . '<br />';
    } else {
        $author = _POSTEDBY . ' ' . mxCreateUserprofileLink($reviewer) . ' ' . _ON . ' ' . mx_strftime(_REVDATEFORMAT, $date) . '<br />';
    }

    $editor = load_class('Textarea', array('name' => 'text', 'value' => $text, 'height' => '300', 'pagebreak' => true));

    for($i = 0; $i < 11; $i++) {
        $select[$i] = ($score == $i) ? ' selected="selected" class="current"' : '';
    }

    include_once('header.php');
    OpenTable();
    echo "<fieldset><legend>" . _REVIEWMOD . "</legend>
    <form action='modules.php?name=$module_name' method='post'>
    <input type='hidden' name='id' value='$id' />
    <input type='hidden' name='name' value='$module_name' />
    <table width='100%' border='0' class='form'>
      <tr>
        <td width='12%'><b>" . _RDATE . "</b></td>
        <td>
          <input type='hidden' name='date' value='$date' />
          <input type='hidden' name='reviewer' value='$reviewer' />
          $author
        </td>
      </tr>
      <tr>
        <td width='12%'><b>" . _RTITLE . "</b></td>
        <td><input type='text' name='title' value='$title' size='60' maxlength='255' /></td>
      </tr>
      <tr>
      <td width='12%'><b>" . _LANGUAGE . ":</b></td>
      <td>" . mxLanguageSelect('rlanguage', $rlanguage, 'language', 1) . "</td></tr>
      <tr valign='top'>
        <td width='12%'><b>" . _RTEXT . "</b></td>
        <td>" . $editor->getHtml() . "</td>
      </tr>
      <tr>
        <td width='12%'><b>" . _SCORE . "</b></td>
        <td>
            <select name='score'>
            <option value=\"10\" $select[10]>10</option>
            <option value=\"9\" $select[9]>9</option>
            <option value=\"8\" $select[8]>8</option>
            <option value=\"7\" $select[7]>7</option>
            <option value=\"6\" $select[6]>6</option>
            <option value=\"5\" $select[5]>5</option>
            <option value=\"4\" $select[4]>4</option>
            <option value=\"3\" $select[3]>3</option>
            <option value=\"2\" $select[2]>2</option>
            <option value=\"1\" $select[1]>1</option>
            <option value=\"0\" $select[0]>0</option>
            </select>
        </td>
      </tr>
      <tr>
        <td width='12%'><b>" . _RLINK . "</b></td>
        <td><input type='text' name='url' value='$url' size='60' maxlength='255' /></td>
      </tr>
      <tr>
        <td width='12%'><b>" . _RLINKTITLE . "</b></td>
        <td><input type='text' name='url_title' value='$url_title' size='60' maxlength='255' /></td>
      </tr>";
    if (mxGetAdminPref('radminreviews')) {
        echo "
      <tr>
        <td width='12%'><b>" . _COVERIMAGE . "</b></td>
        <td>" . revImageBrowse($cover) . "<br />
          <span class=\"tiny\">" . sprintf(_RIMAGEFILEREQ, $revimagepath) . "</span>
        </td>
      </tr><tr>
          <td width='12%'><b>" . _HITS . ":</b></td>
          <td><input type='text' name='hits' value='$hits' size='5' maxlength='5' /></td>
        </tr>
      </table>";
    } else {
        echo "<input type=\"hidden\" name=\"hits\" value=\"$hits\" /></table>";
    }
    echo "<br /><input type='hidden' name='rop' value='preview_review' />
    <input type=\"submit\" value=\"" . _PREMODS . "\" />&nbsp;&nbsp;
    <input type='button' value='" . _CANCEL . "' onclick='history.go(-1)' /></form></fieldset>";

    CloseTable();
    include("footer.php");
}

/* Delete review with all comments, admin only */
function del_review($id_del)
{
    global $prefix, $module_name;
    if (mxGetAdminPref('radminreviews')) {
        sql_query("delete from " . $prefix . "_reviews where id = " . intval($id_del));
        sql_query("delete from " . $prefix . "_reviews_comments where rid='" . intval($id_del) . "'");
        mxRedirect("modules.php?name=$module_name");
    } else {
        mxErrorScreen(_REVIEWNORIGHTS, _REVIEWERROR);
        exit;
    }
}

/* Delete review-comment, admin only */
function del_comment($cid, $id)
{
    global $prefix, $module_name;
    if (mxGetAdminPref('radminreviews')) {
        sql_query("delete from " . $prefix . "_reviews_comments where cid='" . intval($cid) . "'");
        mxRedirect("modules.php?name=$module_name&amp;rop=showcontent&amp;id=$id");
    } else {
        mxErrorScreen(_REVIEWNORIGHTS, _REVIEWERROR);
        exit;
    }
}

/* Displays review-email formular */
function premail_review($id)
{
    global $module_name, $revallowemail;

    if (!$revallowemail) {
        mxErrorScreen(_REVIEWNORIGHTS, _REVIEWERROR);
        exit;
    }
    $title = revGetReviewTitle($id);
    include_once('header.php');
    OpenTable();

    echo "<form action='modules.php?name=$module_name' method='post'>";
    echo "<center><b>" . _REVIEWMAIL . "</b></center><br /><br />";

    echo _REVIEWNAME . '<br /><br />';
    echo "<b>" . $title . "</b><br /><br />";

    if (MX_IS_USER) {
        $cookie = mxGetUserData();
        $from = $cookie['name'];
        $sender = $cookie['email'];
        echo _YOURNAME . ":<br /><input type=\"text\" name=\"from\" value=\"$from\" size=\"60\" /><br /><br />" .
        _REMAIL . ":<br /><input type=\"text\" name=\"sender\" value=\"$sender\" size=\"60\" /><br /><br />";
    } else {
        echo _YOURNAME . ":<br /><input type=\"text\" name=\"from\" value=\"" . $GLOBALS['anonymous'] . "\" size=\"60\" /><br /><br />" .
        _REMAIL . ":<br /><input type=\"text\" name=\"sender\" value=\"\" size=\"60\" /><br /><br />";
    }

    echo _REVIEWTO . '<br />';
    echo "<input type=\"hidden\" name=\"name\" value=\"" . $module_name . "\" />";
    echo "<input type=\"hidden\" name=\"id\" value=\"" . $id . "\" />";
    echo "<input type=\"text\" name=\"receiver\" value=\"\" size=\"60\" /><br /><br />";
    echo "<input type=\"hidden\" name=\"rop\" value=\"mail_review\" />";
    $captcha_object = load_class('Captcha', 'reviewson');
    if ($captcha_object->get_active()) {
        echo '<br /><br />' . $captcha_object->show_complete() . '<br /><br />';

    }
    echo "<input type=\"submit\" value=\"" . _REVIEWSEND . "\" />&nbsp;&nbsp;<input type=\"button\" onclick=\"history.go(-1)\" value=\"" . _CANCEL . "\" />";
    echo "</form>";

    CloseTable();
    echo '<br />';
    include_once("footer.php");
}

/* Sends review-link to an email-address */
function mail_review($from, $sender, $receiver, $id)
{
    global $sitename, $slogan, $module_name, $revallowemail;
    $reverror = false;

    if (!$revallowemail) {
        mxErrorScreen(_REVIEWNORIGHTS, _REVIEWERROR);
        exit;
    }

    $title = revGetReviewTitle($id);
    $from = mxStripSlashes($from);
    $sender = mxStripSlashes($sender);
    $receiver = mxStripSlashes($receiver);

    $captcha_object = load_class('Captcha', 'reviewson');
    if (!$captcha_object->check($_POST, 'captcha')) {
        $reverror = true;
        $reverrormes = _CAPTCHAWRONG . "<br />";
    }

    if (!mxCheckEmail($sender)) {
        $reverror = true;
        $reverrormes = _INVALIDEMAIL . ": " . $sender . "<br />";
    }

    if (pmx_is_mail_banned($sender)) {
        $reverror = true;
        $reverrormes = _INVALIDEMAIL . ": " . $sender . " (" . _MAILISBLOCKED . ")<br />";
    }

    if (!mxCheckEmail($receiver)) {
        $reverror = true;
        $reverrormes = _INVALIDEMAIL . ": " . $receiver . "<br />";
    }

    if (pmx_is_mail_banned($receiver)) {
        $reverror = true;
        $reverrormes = _INVALIDEMAIL . ": " . $receiver . " (" . _MAILISBLOCKED . ")<br />";
    }

    if (empty($from)) {
        $reverror = true;
        $reverrormes = _REVIEWFROMNEEDED;
    }

    include_once('header.php');

    OpenTable();
    echo "<center><b>" . _REVIEWMAIL . "</b></center><br /><br />";

    if ($reverror) {
        echo "<b>" . _REVIEWERROR . "</b><br /><br />";
        echo $reverrormes;
        echo '<br /><br />' . _GOBACK;
    } else {
        $revlink = PMX_HOME_URL . "/modules.php?name=$module_name&amp;rop=showcontent&amp;id=$id";
        $revsubject = "Fwd: " . $title;
        $revmessage = _REVIEWMAIL1 . "\n\n" . _REVIEWMAIL2 . "\t" . $title . "\n" . _RLINK . "\t" . $revlink . "\n\n" . _REVIEWMAIL3 . $from . " (" . $sender . ")\n\n" .
        _REVIEWMAIL4 . _REVIEWMAILSEP . _REVIEWMAIL5 . "\n" . $sitename . " (" . PMX_HOME_URL . ")\n" . $slogan;
        $sendfrom = $sender;

        if (!mxMail($receiver, $revsubject, $revmessage, $sendfrom, "text", '', $from)) {
            echo _REVIEWERROR;
            echo '<br /><br />' . _GOBACK;
        } else {
            echo _REVIEWMAILOK . $receiver;
            echo "<br /><br />[&nbsp;<a href=\"modules.php?name=$module_name&amp;rop=showcontent&amp;id=" . $id . "\">" . _RBACK2 . "</a> | <a href=\"modules.php?name=$module_name\">" . _RBACK . "</a>&nbsp;]";
        }
    }

    CloseTable();
    include_once("footer.php");
}

function revGetReviewTitle($id)
{
    global $prefix;
    static $title, $lastid;
    if ($lastid != $id || !isset($title)) {
        $result = sql_query("select title from " . $prefix . "_reviews WHERE id=" . intval($id));
        list($title) = sql_fetch_row($result);
        $lastid = $id;
    }
    return strip_tags($title);
}

$rop = (isset($_REQUEST['rop'])) ? $_REQUEST['rop'] : '';

$page = (empty($page)) ? 1 : intval($page);
$date = (empty($date)) ? time() : intval($date);
$date = (empty($date)) ? time() : $date;
$hits = (empty($hits)) ? 0 : intval($hits);
$id = (empty($id)) ? 0 : intval($id);
$title = (empty($title)) ? "" : strip_tags($title);
$text = (empty($text)) ? "" : $text;
$cover = (empty($cover)) ? "" : $cover;

$pagetitle = _REVIEWSNAME;
switch ($rop) {
    case '':
        reviews_index();
        break;

    case "showcontent":
        showcontent($id, $page);
        break;

    case "write_review":
        $pagetitle = _WRITEREVIEWFOR . ' ' . $sitename;
        write_review();
        break;

    case "preview_review":
        $pagetitle = _WRITEREVIEWFOR . ' ' . $sitename;
        preview_review($date, $title, $text, $reviewer, $score, $cover, $url, $url_title, $hits, $id, $rlanguage);
        break;

    case _YES:
        $pagetitle = _WRITEREVIEWFOR . ' ' . $sitename;
        send_review($date, $title, $text, $reviewer, $score, $cover, $url, $url_title, $hits, $id, $rlanguage);
        break;

    case "del_review":
        del_review($id_del);
        break;

    case "mod_review":
        mod_review($id);
        break;

    case "postcomment":
        postcomment($id);
        break;

    case "savecomment":
        savecomment($xanonpost, $uname, $id, $score, $comments);
        break;

    case "del_comment":
        del_comment($cid, $id);
        break;

    case "premail_review":
        premail_review($id);
        break;

    case "mail_review":
        mail_review($from, $sender, $receiver, $id);
        break;

    default:
        $pagetitle = _REVIEWSLETTER . ' ' . $rop;
        reviews($rop);
        break;
}

?>