<?php
/**
 * This file is part of
 * pragmaMx - Web Content Management System.
 * Copyright by pragmaMx Developer Team - http://www.pragmamx.org
 *
 * pragmaMx is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * $Revision: 499 $
 * $Author: PragmaMx $
 * $Date: 2022-05-11 14:15:10 +0200 (Mi, 11. Mai 2022) $
 *
 *
 * Base on Reviews Addon
 * Copyright (c) 2000 by Jeff Lambert (jeffx@ican.net) http://www.qchc.com
 * More scripts on http://www.jeffx.qchc.com
 */

defined('mxMainFileLoaded') or die('access denied');

if (!mxGetAdminPref('radminnews')) {
    mxErrorScreen("Access Denied");
    die();
}

$module_name = basename(dirname(__DIR__));
mxGetLangfile($module_name);

/**
 * recommend_admin
 *
 * @package
 * @author ???
 * @copyright Copyright (c) 2014
 * @version $Id: admin.php 605 2022-09-09 13:31:37Z PragmaMx $
 * @access public
 */
class recommend_admin {
    private $errors = array();
    private $form = null;
    private $homepage = '';
    private static $__set = array(); // Konfiguration
    private $kf = null;

    private static $_config = null;

    /**
     * class::__construct()
     *
     * @param string $parameter
     */
    function __construct ($parameter = "")
    {
        global $prefix;

        mxGetLangfile(PMX_MODULE);

        $this->modulname = PMX_MODULE;

        $this->op = $parameter;
        self::$_config = $this->config_load();
        $this->main($this->op);
    }

    /**
     * class::__get()
     *
     * @param mixed $value_name
     * @return
     */
    public function __get($value_name)
    {
        if (isset(self::$__set[$value_name])) {
            return self::$__set[$value_name];
        }
        return false;
    }

    /**
     * class::__set()
     *
     * @param mixed $name
     * @param mixed $val
     * @return
     */
    public function __set($name, $val)
    {
        self::$__set[$name] = $val;
    }

    /**
     * class::main()
     *
     * @param string $action
     * @return
     */
    function main ($op)
    {
        $title = $this->modulname;
		$info=_RECOMMEND_US;
        $tb = load_class('AdminForm', "adminFormMain");
		$allrows=0;
		$show=25;
		$start=isset($_GET['start'])?$_GET['start']:0;
		$link="";
		$redirect=true;
		$pagination="";
		
        switch (pmxAdminForm::CheckButton()) {
            
			case "accept":
				$redirect=false;
			case "save":
			
                $temp = $_POST['config'];
                $this->config_save ($temp) ;
                if ($redirect) mxRedirect("admin.php?op=$title", _CHANGESAREOK, 1);
                break;
			case "delete":
				$liste=implode(",",$_POST['cid']);
				if ($_POST['checkdel']==1) $this->delete_list($liste);
				break;
        }
		
		$link = adminUrl(PMX_MODULE) . '&amp;start=%d';
        if (isset($_GET['show'])) {
            $link .= '&amp;show=' . $show;
        }

        $config = $this->config_load();
		$allrows=$this->get_list_count();
		
		
        $tb = load_class('AdminForm', "adminFormMain");
        $tb->tb_text = mxText("_RECOMMEND");
        $tb->tb_direction = 'right';
        $tb->infobutton = false;
        $tb->tb_pic_heigth = 22;
        $tb->cssclass = "toolbar1";
        $tb->homelink = false;

        if ($allrows > 0 ) {
			$tb->addToolbar("deletex");
			$pagination = mx_pagination($allrows, $start, $show, $link);
			$tb->add("","html","<p style=\"align='right'\">".$pagination."</p>");
		} else {
			$tb->add("","info",_BLK_NOYETCONTENT);
		}
		
		/* Tabellenspalten vorbereiten */
        $rows= $this->get_list($allrows, $start, $show);
		
        $fieldname=array(
            array("name"=>mxText('_ID')),
            array("name"=>mxText('_RECNAME')),
            array("name"=>mxText("_EMAIL")),
            array("name"=>mxText("_RECSENDERNAME")),
            array("name"=>mxText("_RECSENDEREMAIL")),
            array("name"=>mxText("_RECUSER")),
			array("name"=>mxText("_RECSENDERIP")),
			array("name"=>mxText("_RECSENDERTIME")),
			array("name"=>mxText("_PAGE"),"attr"=>"style='max-width:60px'"),
            );
		$attributes=array();
        /* Form elements */
		$checkdel=0;
		$tb->add("","table",$fieldname,$rows);
		$tb->add("","check","checkdel",$checkdel,"Bestätigung : ","Sollen die markierten Einträge wirklich gelöscht werden?","");
        $form = $tb->Show();

        /*
         * Template
         */
        /* Template initialisieren */
        $template = load_class('Template');
        $template->init_path(__FILE__);

        /* hier die Ausgabefelder angeben */
        $template->assign(compact('title', 'form','info','pagination'));

        include('header.php');
        /* Template ausgeben (echo) */
        $template->display('admin.html');
        include('footer.php');
    }
	
	/**
	
	*/
	
	private function get_list($allrows=1, $start=1, $show=25)
	{
		$prefix=pmxBase::prefix();
		$output=array();
		$qry = "SELECT * FROM {$prefix}_recommend ORDER by time desc LIMIT ".$start.",".$show.";";
		$result=sql_query($qry);
		while ($row=sql_fetch_assoc($result)) 
		{
			$row['time']=date(_DATETIME_FORMAT2,$row['time']);
			$row['site']="<a href=\"".$row['site']."\" target=\"_blank\">"._LINK."</a>";
			$user=mxGetUserDataFromUid($row['user']);
			$row['user']=mxCreateUserprofileLink($user['uname']);
			$output[$row['rid']]=$row;
		}
		unset ($result);
		return $output;
	}
	
	private function get_list_count()
	{
		$prefix=pmxBase::prefix();
		$output=array();
		$qry = "SELECT rid FROM {$prefix}_recommend ";
		$result=sql_query($qry);
		return sql_num_rows($result);
	}

	private function delete_list($idlist)
	{
		$prefix=pmxBase::prefix();
		$output=array();
		$qry = "DELETE FROM {$prefix}_recommend where rid IN (".$idlist.");";
		$result=sql_query($qry);
		return sql_affected_rows($result);
	}	

    /**
     * class::config_save()
     * Konfiguration auslesen ....
     *
     * @param array $temp
     * @return
     */
    private function config_save ($temp = array())
    {
        $modulname = $this->modulname;
		$config = load_class("Config",$this->modulname);
        $config->setSection($modulname, $temp);
        return;
    }

    /**
     * class::config_load()
     *
     * @return
     */
    private function config_load ()
    {
        $config = load_class("Config",$this->modulname);
        $modulname = $this->modulname;
        $temp = $config->getSection($modulname);

        if (count($temp) == 0) { // Array leer
            // defaultwerte eintragen
            $temp = $this->GetDefaultConfig();
            $config->getSection($modulname, $temp);
        }

        return $temp;
    }
	   /**
     * class::GetDefaultConfig()
     *
     * @return
     */
    static function GetDefaultConfig()
    {
        $temp = array('var1' => '1',
            'var2' => '2',
            'var3' => '3',
            'var4' => '4',
			'var5' => '0',
            );
        return $temp;
    }
	

}

if (!isset($op)) $op = "";
$tmp = new recommend_admin($op);
$tmp = null;


?>