<?php
/**
 * This file is part of
 * pragmaMx - Web Content Management System.
 * Copyright by pragmaMx Developer Team - http://www.pragmamx.org
 *
 * pragmaMx is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * $Revision: 1151 $
 * $Author: PragmaMx $
 * $Date: 2025-06-14 12:53:03 +0200 (Sa, 14. Jun 2025) $
 */

defined('mxMainFileLoaded') or die('access denied');

$module_name = basename(dirname(__FILE__));
mxGetLangfile($module_name);
include_once(PMX_MODULES_DIR . DS . $module_name . DS . "includes" . DS . "functions.php");

/* erstmal aus der Datenbank lesen */
	$conf = load_class('Book', $module_name);
	$default=getDefaultConfig();
	$root=$conf->getRootRecord();
	$config2 = mx_unserialize($root['config']);
	$config = array_merge($default,$config2);

//mxDebugFuncVars($config);
$plugins=0; // Plugins hier nicht zulassen 
pmxBase::set("plugins",0);

$viewsysteminfo=false;
$text1="";
$text2="";
$intro = '';
$module_info = '';
$design_info = '';
$plugin_info = '';

// wenn Copyright-Informationen angezeigt werden sollen
	if (isset($_GET['op']) && $_GET['op'] == "copyright") {
		
		$array = mxcredit_getinfo();
		extract($array);
		$viewsysteminfo=true;

		$copyrightlink = '<a href="modules.php?name=' . $module_name . '">' . _IMP_LINKTITLE . '</a>';
	} else {
		// keine Copyright-Informationen sollen angezeigt werden
		$copyrightlink = '<a href="modules.php?name=' . $module_name . '&amp;op=copyright#systeminfo">' . _IMP_LINKTITLE . '</a>';
	}

	$lang = (strpos($GLOBALS['currentlang'], 'german') === 0) ? "german" : $GLOBALS["currentlang"];
    $text1 = array();
	
    //$root = $conf->getRootRecord();

	if ($root['text1']== NULL OR trim($root['text1'])=="") {
		$text2 = imp_getdefault($lang);
		$text2 = ($copyrightlink) ? str_replace("{copyrightlink}", '<hr size="1" noshade="noshade" />' . $copyrightlink, $text2) : str_replace("{copyrightlink}", "", $text2);
		$text2 = ($intro) ? str_replace("{developerinfo}", '<hr size="1" noshade="noshade" />' . $intro, $text2) : str_replace("{developerinfo}", "", $text2);
		$text2 = ($module_info) ? str_replace("{module_info}" , '<hr size="1" noshade="noshade" />' . $module_info, $text2) : str_replace("{module_info}" , "", $text2);
		$text2 = ($design_info) ? str_replace("{design_info}" , '<hr size="1" noshade="noshade" />' . $design_info, $text2) : str_replace("{design_info}" , "", $text2);
		$text2 = ($plugin_info) ? str_replace("{plugin_info}" , '<hr size="1" noshade="noshade" />' . $plugin_info, $text2) : str_replace("{plugin_info}" , "", $text2);
		$text2 = trim(clean_tags($text2));
		
	} else {
	    
		$text1 = unserialize($root['text1']);
		$text2=stripslashes($text1[$lang]);
		
		
		if ($config['pmxlink']==1  ) {
			$text2 .= "<div class=\"align-center\"><hr size=\"1\" noshade=\"noshade\" />" . $copyrightlink."</div>";
			$text2 .= '<a name="systeminfo" ></a>';
			
			if ($viewsysteminfo) {
				$text2 .= '<a name="systeminfo" ></a>';
				$text2 .= "<div class=\"align-center\"><hr size=\"1\" noshade=\"noshade\" />" . $intro."</div>";
				
				if ($config['modinfo']==1) {
					$text2 .= "<div class=\"credits \" style=\"padding:10px;height: 600px; overflow: auto;\"><div class=\"align-left\" style=\"margin:10px;\"><hr size=\"1\" noshade=\"noshade\" />" 
							. $module_info
                            .(($config['styleinfo']==1)? $design_info:"")
                            .(($config['plginfo']==1)? $plugin_info:"")
                            ."</div></div>";
                            
				}
			}
		}
	}
	$adminlink=(MX_IS_ADMIN)?"<a href=\"admin.php?op=$module_name\" title=\"\" >["._ADMINMENUEBL."]</a>":"";
	$title=_IMPRESSUM;
	$text=mxPrepareToDisplay($text2);
	
    /*
     * Template
     */
    // Template initialisieren
    $template = load_class('Template');
    $template->init_path(__FILE__);
    /* Variablen an das Template uebergeben */
    $template->assign(
        compact(
            'text',
			'title',
            'module_name',
			'adminlink',
			'copyrightlink'
            ));

    /* Template ausgeben (echo) */

    mxIncludeHeader();

    $template->display('view.page.html');
    
    mxIncludeFooter();



?>
