<?php
/**
 * This file is part of
 * pragmaMx - Web Content Management System.
 * Copyright by pragmaMx Developer Team - http://www.pragmamx.org
 *
 * pragmaMx is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * $Revision: 1151 $
 * $Author: PragmaMx $
 * $Date: 2025-06-14 12:53:03 +0200 (Sa, 14. Jun 2025) $
 *
 * this file based on: Nuke Guestbook v2.0.0
 * Copyright (c) 2001 by Christopher Thorjussen (joffer@online.no), http://www.nukemodules.com
 * Nuke Guestbook is based on Advanced Guestbook 1.01 (PHP/MySQL)
 * Copyright (c) 2001 Chi Kien Uong, http://www.proxy2.de
 * Modified by Francesco Bozzotta, (webmaster@nukeitalia.com), http://www.nukeitalia.com
 * Copyright (c) 2002 by Jochem Schausten (webmaster@tp-krefeld.de), http://www.tp-krefeld.de
 * php-nuke Web Portal System - http://phpnuke.org/
 * Thatware - http://thatware.org/
 */

defined('mxMainFileLoaded') or die('access denied');

/* Konfiguration auslesen */
$NB_setting = NB_GetSettings();

function NB_SubmitForm($entry, $caption, $adminmode = 0)
{
    global $module_name, $NB_setting;

    $html_code = ($NB_setting['allow_html'] == 1) ? _NBHTMLENABLED : _NBHTMLDISABLED;
    $smile_code = ($NB_setting['smilies'] == 1) ? _NBSMILIESON : _NBSMILIESOFF;
    $nb_code = ($NB_setting['nbcode'] == 1) ? _NBNBCODEON : _NBNBCODEOFF;
    $qu = empty($_REQUEST['qu']) ? 0 : 1;
    $item = empty($_REQUEST['item']) ? 0 : intval($_REQUEST['item']);

    $smilies = "";
    if ($NB_setting['smilies'] == 1) {
        $smilies = '<div class="tiny">' . NB_ShowSmilies() . '</div>';
    }
    $allowed = "";
    if ($NB_setting['allow_html'] == 1) {
        $allowed = '&lt;' . implode('&gt; &lt;', mxGetAllowedHtml()) . '&gt;';
        $allowed = '<div class="tiny">' . _NBALLOWEDHTML . '<br />' . $allowed . '</div>';
    }

    $entry = array_merge(NB_DefaultValues(), $entry);

    $entry['id'] = (empty($entry['id'])) ? 0 : intval($entry['id']);
    $entry['nbname'] = (empty($entry['nbname'])) ? '' : $entry['nbname'];
    $entry['uid'] = (empty($entry['uid'])) ? 0 : intval($entry['uid']);
    $entry['nukeuser'] = (empty($entry['nukeuser'])) ? 0 : 1;
    $entry['email'] = (empty($entry['email'])) ? '' : $entry['email'];
    $entry['comment'] = (empty($entry['comment'])) ? '' : $entry['comment'];
    $entry['url'] = (empty($entry['url'])) ? 'http://' : $entry['url'];
    $entry['captcha'] = (empty($entry['captcha'])) ? "" : $entry['captcha'];

    $entry['comment'] = NB_CutEditMessage($entry['comment']);

    if (($entry['nukeuser'] && $NB_setting['regonly']) && !$adminmode) {
        $userfield = '<b>' . $entry['nbname'] . '</b><input type="hidden" name="nbname" value="' . mxEntityQuotes($entry['nbname']) . '" />';
    } else {
        $userfield = '<input type="text" name="nbname" value="' . mxEntityQuotes($entry['nbname']) . '" size="42" maxlength="50" />';
    }

    $postLink = ($adminmode) ? adminUrl($module_name, 'EditEntryConfirm') : 'modules.php?name=' . $module_name;

    ?>
<script language="JavaScript" type="text/javascript">
/*<![CDATA[*/
function openCentered(theURL,winName,winWidth,winHeight,features) {
  var w = (screen.width - winWidth)/2;
  var h = (screen.height - winHeight)/2 - 30;
  features = features+',width='+winWidth+',height='+winHeight+',top='+h+',left='+w+'';
  window.open(theURL,winName,features);
}
/*]]>*/
</script>
<?php
    echo '
	<form action="' . $postLink . '" method="post" name="gbForm" id="gbForm" style="margin: 0px;">
	<fieldset>
		<legend>' . $caption . '</legend>
	<table width="100%" border="0" cellspacing="1" cellpadding="4" class="bgcolor1">
	';
    if (!$adminmode) {
        echo '
	  <tr>
	    <td colspan="2" class="bgcolor2 tiny">' . _NBFILLOUT . '</td>
	  </tr>
		';
    }
    echo '
	  <tr>
	    <td class="bgcolor2" width="25%">' . _NBNAME . ':&nbsp;<span class="required">*</span></td>
	    <td class="bgcolor3">' . $userfield . '</td>
	  </tr>
	  <tr>
	    <td class="bgcolor2" width="25%">' . _NBEMAIL . ':</td>
	    <td class="bgcolor3"><input type="text" name="email" value="' . mxEntityQuotes($entry['email']) . '" size="50" maxlength="60" /></td>
	  </tr>
		';
    if (!empty($NB_setting['showurl'])) {
        echo '
      <tr>
	    <td class="bgcolor2" width="25%">' . _NBHOMEPAGE . ':</td>
	    <td class="bgcolor3"><input type="text" name="url" value="' . mxEntityQuotes($entry['url']) . '" size="50" maxlength="70" /></td>
	  </tr>
		';
    }
    echo '
	  <tr>
	    <td class="bgcolor2" width="25%" valign="top">' . _NBYOURMESSAGE . ':&nbsp;<span class="required">*</span><br /><br />
		<div align="left" class="tiny">
        <ul class="tiny">
          <li>' . $html_code . '</li>
          <li>' . $smile_code . '</li>
          <li>' . $nb_code . '</li>
        </ul>
        <a href="javascript:openCentered(\'modules.php?name=' . $module_name . '&amp;file=bbcode\',\'codes\',\'640\',\'450\',\'scrollbars=yes\')">' . _NBSHOWLEGEND . '</a>
      </div>
	    </td>
	    <td class="bgcolor3"><textarea cols="60" rows="12" name="comment" id="gb_comment">' . htmlspecialchars($entry['comment']) . '</textarea>' . $smilies . ' ' . $allowed . '</td>
	  </tr>
	  <tr>
	    <td class="bgcolor2" colspan="2" align="center">&nbsp;
	      <input type="hidden" name="name" value="' . $module_name . '" />
				<input type="hidden" name="nukeuser" value="' . $entry['nukeuser'] . '" />
				<input type="hidden" name="uid" value="' . $entry['uid'] . '" />
				<input type="hidden" name="id" value="' . $entry['id'] . '" />
				<input type="hidden" name="item" value="' . $item . '" />
				';
    if ($adminmode) {
        echo '<input type="submit" value="' . _NBSAVECHANGES . '" />
				<input type="hidden" name="qu" value="' . $qu . '" /> ';
    } else {
        $captcha_object = load_class('Captcha', 'guestbookon');
        if ($captcha_object->get_active()) {
            echo '</td></tr><tr><td colspan="2" class="bgcolor2"><center>' . $captcha_object->complete() . '<span class="required">*</span></center></td></tr>';
//            echo '<tr><td class="bgcolor2" width="25%" valign="top">' . $captcha_object->caption() . '</td><td class="bgcolor3">' . $captcha_object->inputfield() . '</td></tr>
//				<tr><td colspan="2" class="bgcolor2">' . $captcha_object->reloadbutton();
        }
        echo '<tr><td colspan="2" class="bgcolor2"><input type="submit" name="op" value="' . _NBSUBMIT . '" />
				<input type="submit" name="op" value="' . _NBPREVIEW . '" /> ';
    }
    echo '
	    </td>
	  </tr>
	</table>
	</fieldset>
	</form>
	';
}

function NB_ViewEntry($entry, $adminmode = 0)
{
    global $bgcolor1, $bgcolor2, $bgcolor3;
    global $module_name, $NB_setting, $prefix;
    static $i = 0;
    $i++;

    $item = (isset($entry['item'])) ? intval($entry['item']) : 0;

    if ($NB_setting['allow_html'] == 1) {
        $comment = mxNL2BR(mxPrepareToDisplay($entry['comment']));
    } else {
        $comment = htmlspecialchars($entry['comment']);
        $comment = nl2br($comment);
    }

    $comment = NB_GetEditMessage($comment);

    if ($NB_setting['smilies'] == 1) {
        $comment = NB_Emotion($comment);
    }

    if ($NB_setting['nbcode'] == 1) {
        $comment = NB_Code($comment);
    }

    $comment = FixLongWords($comment, $NB_setting['max_wordlength']);

    $gotop = '<a href="#nb_top">' . mxCreateImage('modules/' . $module_name . '/images/up.png', _TOP, 0, 'title="' . _TOP . '" style="margin-left:1em;"') . '</a>';
    $thread = _NBNAVIENTRY . ' <a style="vertical-align: top; text-decoration: none;" name="gb-' . $entry['id'] . '" id="gb-' . $entry['id'] . '">#' . ((isset($entry['thread'])) ? intval($entry['thread']) : $entry['id']) . '</a>';
    $date = mx_strftime(_DATESTRING . ' %H:%M', $entry['date']);
    $date = '<span class="content">' . mxCreateImage('modules/' . $module_name . '/images/post.gif', $date) . '&nbsp;' . $date . '<br />' . $thread . '</span>';
    $username = ($entry['uid'] && $entry['nukeuser']) ? mxCreateUserprofileLink($entry['nbname']) : $entry['nbname'];
    $username = '<span class="option"><b>' . $username . '</b></span>' . (($entry['uid'] && $entry['nukeuser']) ? '' : ' <span class="tiny">(' . _NBASGUEST . ')</span>');
    $userdata = ($entry['email']) ? '<a href="mailto:' . mxPrepareToDisplay($entry['email']) . '">' . mxCreateImage('modules/' . $module_name . '/images/email.gif', _NBEMAIL) . '</a> ' : '';
    if (!empty($NB_setting['showurl'])) {
        $userdata .= ($entry['url']) ? '<a href="' . $entry['url'] . '" target="_blank">' . mxCreateImage('modules/' . $module_name . '/images/homepage.gif', _NBHOMEPAGE) . '</a> ' : '';
    }
    $admin = '';
    if (MX_IS_ADMIN) {
        if (!$adminmode) {
            $admin .= '<a href="' . adminUrl($module_name, 'EditEntry', 'id=' . $entry['id'] . '&amp;item=' . $item) . '">' . mxCreateImage('modules/' . $module_name . '/images/edit.gif', _NBEDITENTRY, 0, 'title="' . _NBEDITENTRY . '" style="margin-left:.4em;"') . '</a>';
            $admin .= '<a href="' . adminUrl($module_name, 'DeleteEntry', 'id=' . $entry['id'] . '&amp;item=' . $item) . '">' . mxCreateImage('modules/' . $module_name . '/images/delete.gif', _NBDELETEPOST, 0, 'title="' . _NBDELETEPOST . '" style="margin-left:.4em;"') . '</a>';
        }
        // Immer die IP speichern, siehe Bug-ID 933, aber
        // fuer alte Eintraege muss die Abfrage auf einen Hostnamen drin bleiben
        $hostname = (preg_match('#^[-a-z_]+#', $entry['host'])) ? 'Host' : 'IP';
        $admin .= mxCreateImage('modules/' . $module_name . '/images/host.gif', $hostname, 0, 'title="' . $hostname . ': ' . $entry['host'] . '" style="margin-left:.4em;"');
    }

    $out = '
	<tr>
	   <td colspan="2" style="height: 10px; background-color: ' . $bgcolor2 . '; border: 1px solid ' . $bgcolor1 . '; border-bottom: none; padding: 5px;">
			<table width="100%" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td align="left">' . $username . '</td>
				<td align="right">' . $date . '</td>
			</tr>
			</table>
		</td>
	</tr>
	<tr align="left" valign="top">
	   <td width="10%" align="left" style="background-color: ' . $bgcolor2 . '; border-left: 1px solid ' . $bgcolor1 . '; padding: 5px;"><div class="tiny" style="white-space: nowrap;">' . $userdata . '<br /></div></td>
	   <td width="90%" rowspan="2" style="height: 50px; background-color: ' . $bgcolor3 . '; border: 1px solid ' . $bgcolor1 . '; padding: 5px;"><div class="content">' . $comment . '<br /></div></td>
	</tr>
	<tr>
	   <td width="10%" align="right" valign="bottom" style="height: 10px; background-color: ' . $bgcolor2 . '; border-left: 1px solid ' . $bgcolor1 . '; border-bottom: 1px solid ' . $bgcolor1 . ';"><div class="tiny" style="white-space: nowrap;"><br />' . $admin . '</div></td>
	</tr>
	';
    if (!$adminmode) {
        $out .= '
		<tr><td colspan="2" align="right">' . $gotop . '</td></tr>
		';
    }
    echo $out;
}

/**
 * NB_CheckEntry()
 * Internal function used to check for empty name
 * or message field, which in turn call on gb_error
 * if needed
 *
 * @param mixed $entry
 * @return
 */
function NB_CheckEntry($entry)
{
    global $NB_setting;

    $entry = array_merge(NB_DefaultValues(), $entry);

    $entry['nbname'] = trim(strip_tags($entry['nbname']));
    $name_check = '';
    if (MX_IS_USER) {
        $userinfo = mxGetUserData();
        $name_check = $userinfo['uname'];
        if (empty($entry['nbname']) || $NB_setting['regonly']) {
            $entry['uid'] = $userinfo['uid'];
            $entry['nbname'] = $userinfo['uname'];
        }
    }

    if (empty($entry['nbname'])) {
        gb_error(_NBERRORNAME, $entry);
    } else {
        if ($name_check != $entry['nbname']) {
            $checkdata = mxGetUserDataFromUsername($entry['nbname']);
            if (!empty($checkdata['uname'])) {
                $entry['nbname'] = '';
                gb_error(sprintf(_USERNAMENOTALLOWED, $checkdata['uname']), $entry);
            }
        }
    }

    $entry['comment'] = trim($entry['comment']);
    if (empty($entry['comment'])) {
        gb_error(_NBERRORMSG, $entry);
    }
    // vermeiden, dass Systemkommentare gepostet werden können
    $entry['comment'] = preg_replace('#(<!-- ~)(!.*!)(~ -->)#s', '<!-- &#126;$2&#126; -->', $entry['comment']);

    $entry['email'] = trim(strip_tags($entry['email']));
    if (!mxCheckEmail($entry['email']) || pmx_is_mail_banned($entry['email'])) {
        $entry['email'] = '';
    }
    if (empty($NB_setting['showurl']) || !preg_match("#^http://[_a-z0-9-]+\.[_a-z0-9-]+#i", $entry['url'])) {
        $entry['url'] = '';
    }

    $entry['url'] = trim(mxCutHTTP(strip_tags($entry['url'])));
    if (htmlspecialchars($entry['url']) != $entry['url']) {
        $entry['url'] = '';
    }

    return $entry;
}

function FixLongWords($string, $wordlength)
{
    $wordlength = intval($wordlength);
    if (empty($wordlength)) {
        return $string;
    }
    $mystring = "";
    $streng = preg_split('#[[:space:]]#', $string);
    reset ($streng);
    //while (list(, $temp) = each ($streng)) {
	foreach($streng as $val=>$temp) {
        if (strlen($temp) > $wordlength && !preg_match('#(https?|ftp)://#', $temp)) {
            $temp = chunk_split($temp, $wordlength);
            $mystring .= $temp;
        } else {
            $mystring .= $temp . " ";
        }
    }
    return $mystring;
}

function NB_GetSmilies()
{
    /* zum Verändern der Smilies, eine entsprechende custom.smilies.php anlegen.
     * Nicht diese Systemdatei verändern!!
     */
    if (file_exists(dirname(__FILE__) . DS . 'custom.smilies.php')) {
        include(dirname(__FILE__) . DS . 'custom.smilies.php');
        if (isset($smilies) && is_array($smilies)) {
            return $smilies;
        }
    }

    $smilies = array(/* code => Bild */
        ':)' => 'smilie1.gif',
        ':-)' => 'smilie1.gif',
        ':(' => 'smilie2.gif',
        ':-(' => 'smilie2.gif',
        ';)' => 'smilie3.gif',
        ';-)' => 'smilie3.gif',
        ':o' => 'smilie4.gif',
        ':-o' => 'smilie4.gif',
        ':D' => 'smilie5.gif',
        ':-D' => 'smilie5.gif',
        ':p' => 'smilie6.gif',
        ':-p' => 'smilie6.gif',
        ':P' => 'smilie6.gif',
        ':-P' => 'smilie6.gif',
        ':cool:' => 'smilie7.gif',
        ':rolleyes:' => 'smilie8.gif',
        ':mad:' => 'smilie9.gif',
        ':eek:' => 'smilie10.gif',
        ':confused:' => 'smilie11.gif',
        );

    return $smilies;
}

function NB_ShowSmilies()
{
    global $module_name;
    $folder = 'modules/' . $module_name . '/images/';

    $smilies = NB_GetSmilies();
    $images = array();
    foreach($smilies as $key => $val) {
        $code_js = str_replace('\'', '\\x27', $key);
        if ($key && $val) {
            if (!isset($images[$val])) {
                $images[$val] = '<td class="smiley_cell" title="' . $key . '" onclick="insert_text(\' ' . $code_js . ' \');">' . mxCreateImage($folder . $val, $key, 0, 'style="cursor: pointer;"') . '</td>';
            }
        } else {
            $images[$key] = '</tr><tr valign="middle">';
        }
    }

    $smilies = '
	<script type="text/javascript">
	<!--
	// Unclassified NewsBoard
	// Copyright 2003-4 by Yves Goergen
	// Homepage: http://newsboard.unclassified.de

	textbox = document.getElementById("gbForm").gb_comment;

	function insert_text(what)	{
		if (textbox.createTextRange)		{
			textbox.focus();
			document.selection.createRange().duplicate().text = what;
			textbox.focus();
		}
		else if (textbox.selectionStart >= 0)		{
			// Mozilla without selected text
			var start_selection = textbox.selectionStart;
			var scroll_top = textbox.scrollTop;
			var scroll_left = textbox.scrollLeft;

			// fetch everything from start of text area to selection start
			var start = textbox.value.substring(0, start_selection);
			// fetch everything from end of selection to end of text area
			var end = textbox.value.substring(start_selection, textbox.textLength);

			textbox.value = start + what + end;

			textbox.selectionStart = textbox.selectionEnd = start_selection + what.length;
			textbox.focus();
			textbox.scrollTop = scroll_top;
			textbox.scrollLeft = scroll_left;
		}
		else		{
			textbox.value += what;
			textbox.focus();
		}
	}
	//-->
	</script>
	<table cellspacing="0" cellpadding="3"><tr valign="middle">' . implode(' ', $images) . '</tr></table>';
    return $smilies;
}

function NB_Emotion($message)
{
    static $replaces;

    if (!isset($replaces)) {
        global $module_name;
        $folder = 'modules/' . $module_name . '/images/';

        $smilies = NB_GetSmilies();

        $replaces = array();
        $images = array();
        foreach($smilies as $key => $val) {
            if ($key && $val) {
                if (!isset($images[$val])) {
                    // gleiche Bilder nur 1x generieren
                    $images[$val] = mxCreateImage($folder . $val, $key);
                }
                $replaces[$key] = $images[$val];
            }
        }
    }
    return str_replace(array_keys($replaces), array_values($replaces), $message);
}

function NB_Code($string)
{
    global $NB_setting;
    $string = preg_replace("#\[img\](.*?\.(png|jpe?g|gif))[[:space:]]*?\[/img\]#si", "<img src=\"\\1\" border=\"0\" />", $string);
    $string = preg_replace("#\[b\](.*)\[/b\]#siU", "<b>\\1</b>", $string);
    $string = preg_replace("#\[i\](.*)\[/i\]#siU", "<i>\\1</i>", $string);
    $string = preg_replace("#\[u\](.*)\[/u\]#siU", "<u>\\1</u>", $string);
    $string = preg_replace("#\[email\]([^\[]*)\[/email\]#si", "<a href=\"mailto:\\1\">\\1</a>", $string);
    $string = preg_replace("#\[hr\]#i", "<hr />", $string);
    // url's nur umwandeln, wenn Anzeige der url eingeschaltet
    if (empty($NB_setting['showurl'])) {
        $string = preg_replace("#\[url\]www.([^\[]*)\[/url\]#i", "\\1", $string);
        $string = preg_replace("#\[url\]([^\[]*)\[/url\]#i", "\\1", $string);
        $string = preg_replace("#\[url=http://([^\[]+)\]([^\[]*)\[/url\]#i", "\\2", $string);
    } else {
        $string = preg_replace("#\[url\]www.([^\[]*)\[/url\]#i", "<a href=\"http://www.\\1\" target=\"_blank\">\\1</a>", $string);
        $string = preg_replace("#\[url\]([^\[]*)\[/url\]#i", "<a href=\"\\1\" target=\"_blank\">\\1</a>", $string);
        $string = preg_replace("#\[url=http://([^\[]+)\]([^\[]*)\[/url\]#i", "<a href=\"http://\\1\" target=\"_blank\">\\2</a>", $string);
    }
    return $string;
}

function NB_NaviForm()
{
    global $module_name, $NB_setting;
    $total = NB_GetTotalCount();
    $item = (isset($_REQUEST['item'])) ? intval($_REQUEST['item']) : 0;

    $options = array();
    $remain = 0;
    // $total % $NB_setting['entries_per_page'];
    for ($max = $total; $max > 0; $max -= $NB_setting['entries_per_page']) {
        $min = $max - $NB_setting['entries_per_page'] + 1;
        if ($min < 1) $min = 1;
        $options[] = '<option value="' . $remain . '"' . (($item === $remain) ? 'selected="selected" class="current"' : '') . '>' . _NBNAVIENTRY . ' ' . $min . '-' . $max . "</option>\n"; #
        $remain += $NB_setting['entries_per_page'];
    }

    if (count($options) > 1) {
        $options = implode('', $options);
        return '
        <form action="modules.php" name="gb_navi" id="gb_navi" style="margin: 0px; white-space: nowrap;">
        <input type="hidden" name="name" id="name" value="' . $module_name . '" />
        <select name="item" onchange="document.getElementById(\'gb_navi\').submit();">
        ' . $options . '
        </select>
        <input type="submit" id="gb_subi" value="' . _NBGO . '" style="visibility: inherit;" />
        </form>
        <script type="text/javascript">
            <!--
            document.getElementById(\'gb_subi\').style.visibility=\'hidden\';
            //-->
        </script>
		';
    }
}

function NB_GetTotalCount()
{
    global $prefix, $NB_setting;
    static $total;
    if (!isset($total)) {
        $sql_result = sql_query("select count(id) as total from {$prefix}_{$NB_setting['dbtable']}");
        list($total) = sql_fetch_row($sql_result);
    }
    return intval($total);
}

function NB_GetSettings()
{
    static $NB_setting;
    if (isset($NB_setting)) {
        return $NB_setting;
    }
    global $module_name;
    include(PMX_MODULES_DIR . DS . $module_name . '/include/config.inc.php');
    if (!isset($NB_setting['regonly']) || !isset($NB_setting['waitseconds'])) {
        // zur Kompatibilitaet mit aelteren config-Dateien...
        @$NB_setting['regonly'] = (isset($NB_RegOnly)) ? $NB_RegOnly : 1 ;
        @$NB_setting['gbnotify'] = (isset($gbnotify)) ? $gbnotify : 1 ;
        @$NB_setting['waitseconds'] = (isset($waitseconds)) ? $waitseconds : 120 ;
        @$NB_setting['entries_per_page'] = (isset($entries_per_page)) ? $entries_per_page : 10 ;
        @$NB_setting['allow_html'] = (isset($allow_html)) ? $allow_html : 0 ;
        @$NB_setting['smilies'] = (isset($smilies)) ? $smilies : 1 ;
        @$NB_setting['nbcode'] = (isset($nbcode)) ? $nbcode : 1 ;
        @$NB_setting['max_wordlength'] = (isset($max_wordlength)) ? $max_wordlength : 80 ;
        @$NB_setting['confirmation'] = (isset($confirmation)) ? $confirmation : 1 ;
        @$NB_setting['showurl'] = (isset($showurl)) ? $showurl : 1 ;
        @$NB_setting['rightblocks'] = (isset($rightblocks)) ? $rightblocks : 0 ;
        @$NB_setting['dbtable'] = (isset($dbtable)) ? $dbtable : 'nukebook' ;
    }
    return $NB_setting;
}

function NB_isPostAllowed()
{
    global $NB_setting;
    return !($NB_setting['regonly'] && !MX_IS_USER && !MX_IS_ADMIN);
}

function NB_SetEditMessage($msg)
{
    $msg = NB_CutEditMessage($msg);
    $msg .= '<!-- ~!~' . time() . '~!~ -->';
    return $msg;
}

function NB_GetEditMessage($msg)
{
    if (preg_match('#(.*)(?:&lt;|<)!-- ~!~([0-9]+)~!~ --(?:&gt;|>)(.*)#s', $msg, $matches)) { // eimsux
        if ($GLOBALS['NB_setting']['allow_html'] == 1) {
            $msg = trim($matches[1] . ' ' . $matches[3]) . '<br /><div align="right" class="tiny">' . _NBEDITBYADMIN . ': ' . mx_strftime(_SHORTDATESTRING, $matches[2]) . '</div>';
        } else {
            $msg = trim($matches[1] . ' ' . $matches[3]) . "\n\n[&nbsp;" . _NBEDITBYADMIN . ': ' . mx_strftime(_SHORTDATESTRING, $matches[2]) . '&nbsp;]';
        }
    }
    return $msg;
}

function NB_CutEditMessage($msg)
{
    $msg = trim(preg_replace('#(.*)<!-- ~!~([0-9]+)~!~ -->(.*)#s', '$1 $3', $msg));
    return $msg;
}

function NB_DefaultValues()
{
    $defaults = array(/* Standardwerte */
        'id' => 0,
        'name' => '',
        'nbname' => '',
        'uid' => 0,
        'email' => '',
        'url' => 'http://',
        'date' => time(),
        'host' => MX_REMOTE_ADDR,
        'comment' => '',
        'nukeuser' => MX_IS_USER,
        'captcha' => '',
        );

    return $defaults;
}

?>