<?php
/**
 * This file is part of
 * pragmaMx - Web Content Management System.
 * Copyright by pragmaMx Developer Team - http://www.pragmamx.org
 *
 * pragmaMx is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * $Revision: 1145 $
 * $Author: PragmaMx $
 * $Date: 2025-02-17 19:02:01 +0100 (Mo, 17. Feb 2025) $
 *
 *
 */

defined('mxMainFileLoaded') or die('access denied');

$module_name = basename(dirname(__FILE__));
mxGetLangfile($module_name);
$pagetitle = _ENCYCLOPEDIA;
pmxBase::set("plugins",1);

function encysearch($eid)
{
    global $module_name;
    echo "<center><form action=\"modules.php?name=$module_name&amp;file=search\" method=\"post\">"
     . "<input type=\"text\" size=\"20\" name=\"query\" />&nbsp;&nbsp;"
     . "<input type=\"hidden\" name=\"eid\" value=\"$eid\" />"
     . "<input type=\"submit\" value=\"" . _SEARCH . "\" />"
     . "</form>"
     . "</center>";
}

/* Alphabet abhängig von Sprache ermitteln */
function get_alphabet()
{
    $alphabet = array();

    if (!_SPECIALCHARS_ONLY) {
        for ($i = 65; $i <= 90; $i++) {
            $alphabet[] = chr($i);;
        }
    }

    /* Sonderzeichen aus Sprachdatei, aber nur die, die auch als Gross-Zeichen existieren, also nicht das ß */
    include_once(UTF8 . DS . 'str_split.php');
    $uppers = utf8_str_split(utf8_strtoupper(_SPECIALCHARS));
    $lowers = utf8_str_split(utf8_strtolower(_SPECIALCHARS));
    $more = array_unique(array_diff($uppers, $lowers));

    $alphabet = array_merge($alphabet, $more, range(1, 9));
    $alphabet[] = 0;

    return $alphabet;
}

/* Builds the alphabetic sorting-options, index-page */
function alpha($eid)
{
    global $module_name, $prefix;

    $alphabet = get_alphabet();
    $result = sql_query("SELECT DISTINCT UPPER(LEFT(title, 1)) from " . $prefix . "_encyclopedia_text WHERE eid=" . intval($eid));
    while (list($letter) = sql_fetch_row($result)) {
        $titles[$letter] = $letter;
        // verwendete (Sonder)Zeichen ans Alphabet anfügen
        $alphabet[] = $letter;
    }
    $alphabet = array_unique($alphabet);
    $num = count($alphabet) - 1;
    $half = ceil($num / 2);

    echo "<center>" . _ENCYSELECTLETTER . "</center><br /><br />";
    echo "<center>[ ";
    $counter = 0;
    foreach ($alphabet as $ltr) {
        if (isset($titles[$ltr])) {
            echo "<a href=\"modules.php?name=$module_name&amp;op=terms&amp;eid=$eid&amp;ltr=$ltr\">$ltr</a>";
        } else {
            echo $ltr;
        }
        if ($counter == $half) {
            echo " ]\n<br />\n[ ";
        } elseif ($counter != $num) {
            echo "&nbsp;|&nbsp;";
        }
        $counter++;
    }
    echo " ]</center><br /><br />\n";
    encysearch($eid);
    echo "<center>" . _GOBACK . "</center>";
}

function CrossLinker(&$c, $eid, $t)
{
    global $module_name, $prefix, $textcolor1;

    $y = '';

    $result = sql_query("select tid, title from " . $prefix . "_encyclopedia_text where eid=" . intval($eid) . " order by length('title') desc, 'title' asc");
    while (list($ntid, $ntit) = sql_fetch_row($result)) {
        $x = "<a href=\"modules.php?name=" . $module_name . "&amp;op=content&amp;tid=" . $ntid . "\">" . $ntit . "</a>";
        if ($c && $ntit && strpos($c, $ntit) > 0) {
            if ($ntit <> $t) {
                $y .= '[ ' . $x . ' ] ';
            }
        }
    }
    if ($y) {
        $c = $c . "<br /><br /><p style=\"border-width:thin; border-color:{$textcolor1}; border-style:dashed; padding:5px;\" align=\"left\">" . _ENCYCROSSLINKS . ":<br />" . $y . "</p>";
    }
    return $c;
}

function list_content()
{
    global $module_name, $prefix, $pagetitle;
    $eid = (empty($_REQUEST['eid'])) ? 0 : intval($_REQUEST['eid']);
    $result = sql_query("select title, description from " . $prefix . "_encyclopedia where eid=" . intval($eid));
    list($title, $description) = sql_fetch_row($result);
    $pagetitle = _ENCYCLOPEDIA . ', ' . $title;
    include("header.php");
    title(_ENCYCLOPEDIA);
    OpenTable();
    echo "<center><b>$title</b></center><br />"
     . "<p align=\"justify\">$description</p>";
    CloseTable();
    echo '<br />';
    OpenTable();
    alpha($eid);
    CloseTable();
    echo '<br />';
    OpenTable();
    echo "<center><font class=\"tiny\">" . _COPYRIGHT . "</font></center>";
    CloseTable();
    include("footer.php");
}

function terms()
{
    global $module_name, $prefix, $pagetitle;

    $eid = (empty($_REQUEST['eid'])) ? 0 : intval($_REQUEST['eid']);
    $ltr = (empty($_REQUEST['ltr'])) ? 'A' : strtoupper(substr($_REQUEST['ltr'], 0, 1));

    $count = -1;
    $items = 2; // Anzahl gewünschter Spalten
    $result = sql_query("select active, title from " . $prefix . "_encyclopedia where eid=" . intval($eid));
    list($active, $title) = sql_fetch_row($result);
    $pagetitle = _ENCYCLOPEDIA . ', ' . $title;
    include("header.php");
    title(_ENCYCLOPEDIA);
    OpenTable();
    if (($active == 1) OR (MX_IS_ADMIN)) {
        if (($active != 1) AND (MX_IS_ADMIN)) {
            echo "<center>" . _YOURADMINENCY . "</center><br /><br />";
        }
        echo "<center>" . _SECTIONSTERMSINENCY . " &quot;<strong>{$title}</strong>&quot;:</center><br /><br />"
         . "<table align=\"center\">";
        $result = sql_query("select tid, title from " . $prefix . "_encyclopedia_text WHERE UPPER(title) LIKE '" . mxAddSlashesForSQL($ltr) . "%' AND eid=" . intval($eid) . " ORDER BY title");
        if (sql_num_rows($result) == 0) {
            echo "<center><i>" . _NOCONTENTFORLETTER . " $ltr.</i></center>";
        } while (list($tid, $title) = sql_fetch_row($result)) {
            if ($count == -1) {
                $count = 0;
                echo "<tr>";
            }
            $count = $count + 1;
            echo "<td>&nbsp;&middot;&nbsp;<a href=\"modules.php?name=$module_name&amp;op=content&amp;tid=$tid\"><font class=\"option\">$title</font></a></td>";
            if ($count == $items) {
                $count = 0;
                echo "</tr><tr>";
            }
        }
        $fill = $items - $count;
        if ($fill != 0) {
            echo "<td colspan=\"{$fill}\">&nbsp;</td>";
        }
        if ($count == 0) {
            echo "</tr>";
        }
        echo "</tr></table><br /><br />";
        alpha($eid);
    } else {
        echo "<center>" . _ENCYNOTACTIVE . '<br /><br />' . _GOBACK . "</center>";
    }
    CloseTable();
    include("footer.php");
}

function content()
{
    global $prefix, $sitename, $module_name, $pagetitle;
    $tid = (empty($_REQUEST['tid'])) ? 0 : intval($_REQUEST['tid']);
    $ltr = (empty($_REQUEST['ltr'])) ? '' : substr($_REQUEST['ltr'], 0, 1);
    $page = (empty($_REQUEST['page'])) ? 1 : intval($_REQUEST['page']);
    $query = (empty($_REQUEST['query'])) ? '' : strip_tags($_REQUEST['query']);

    $result = sql_query("SELECT * from " . $prefix . "_encyclopedia_text where tid='$tid'");
    $ency = sql_fetch_array($result);
    $result = sql_query("select active, title from " . $prefix . "_encyclopedia where eid=" . intval($ency['eid']));
    list($active, $enc_title) = sql_fetch_row($result);

    $pagetitle = _ENCYCLOPEDIA . ', ' . $enc_title;
    include("header.php");
    title(_ENCYCLOPEDIA);
    OpenTable();
    if (($active == 1) OR ($active == 0 AND (MX_IS_ADMIN))) {
        sql_query("update " . $prefix . "_encyclopedia_text set counter=counter+1 where tid='" . intval($tid) . "'");
        if (MX_IS_ADMIN) {
            echo '<div style="text-align:right;"><a href="' . adminUrl($module_name, 'text_edit', 'tid=' . $tid) . '">' . mxCreateImage('images/edit.gif', _EDIT) . '</a>&nbsp;<a href="' . adminUrl($module_name, 'text_delete', 'tid=' . $tid . '&amp;ok=0') . '">' . mxCreateImage('images/delete.gif', _DELETE) . '</a>&nbsp;</div>';
        }
        echo "<font class=\"title\">$ency[title]</font><br />";
        if ($ency['autolink']) {
            // Wenn gesetzt, automatisches Verlinken - Ver.: 0.1.7
            CrossLinker($ency['text'], $ency['eid'], $ency['title']);
        }
        $contentpages = pmx_split_pages($ency["text"]);
        $pageno = count($contentpages);
        if ($page == 0 || $page < 1)
            $page = 1;
        if ($page > $pageno)
            $page = $pageno;
        $arrayelement = intval($page);
        $arrayelement --;
        if ($pageno > 1) {
            echo _PAGE . ": $page/$pageno<br />";
        }
        if (!empty($query)) {
            $contentpages[$arrayelement] = str_replace($query, "<b>" . mxPrepareToDisplay($query) . "</b>", $contentpages[$arrayelement]);
            $fromsearch = "&amp;query=" . urlencode($query);
        } else {
            $fromsearch = "";
        }
        echo "<div align=\"justify\">" . $contentpages[$arrayelement] . "</div>";
        $next_page = '';
        $previous_page = '';
        if ($page >= $pageno) {
            $next_page = "";
        } else {
            $next_pagenumber = $page + 1;
            if ($page != 1) {
                $next_page .= "- ";
            }
            $next_page .= '<a href="modules.php?name=' . $module_name . '&amp;op=content&amp;tid=' . $tid . '&amp;page=' . $next_pagenumber . $fromsearch . '">' . _NEXT . ' (' . $next_pagenumber . '/' . $pageno . ')</a> <a href="modules.php?name=' . $module_name . '&amp;op=content&amp;tid=' . $tid . '&amp;page=' . $next_pagenumber . '">' . mxCreateImage(PMX_IMAGE_PATH . 'next.png', _NEXT) . '</a>';
        }
        if ($page <= 1) {
            $previous_page = "";
        } else {
            $previous_pagenumber = $page - 1;
            $previous_page = '<a href="modules.php?name=' . $module_name . '&amp;op=content&amp;tid=' . $tid . '&amp;page=' . $previous_pagenumber . $fromsearch . '">' . mxCreateImage(PMX_IMAGE_PATH . 'previous.png', _PREVIOUS) . '</a> <a href="modules.php?name=' . $module_name . '&amp;op=content&amp;tid=' . $tid . '&amp;page=' . $previous_pagenumber . $fromsearch . '">' . _PREVIOUS . ' (' . $previous_pagenumber . '/' . $pageno . ')</a>';
        }
        echo "<br /><center>$previous_page $next_page<br /><br />" . _GOBACK . "</center><br />";
        echo "<p align=\"right\"><a href=\"modules.php?name=$module_name&amp;op=list_content&amp;eid=$ency[eid]\">$enc_title</a></p>";
        if ($page == $pageno) {
            //echo "<p align=\"right\" class=\"tiny\">Copyright &copy; " . _SECTIONSBY . " " . $sitename . " - ($ency[counter] " . _SECTIONSREADS . ")</p>";
        }
    } else {
        echo _SECTIONSISNA;
    }
    CloseTable();
    include("footer.php");
}

function list_themes()
{
    global $prefix, $sitename, $module_name;
    $result = sql_query("SELECT eid, title, description, elanguage from " . $prefix . "_encyclopedia WHERE active=1 " . pmx_multilang_query('elanguage', 'AND') . "");
    if (sql_num_rows($result) > 1) {
		include("header.php");
		title(_ENCYCLOPEDIA);
		OpenTable();
		echo "<center>" . _AVAILABLEENCYLIST . " &quot;" . $sitename . "&quot;:</font></center><br /><br />";
        echo '<div style="padding-left: 30px;">';
        while (list($eid, $title, $description, $elanguage) = sql_fetch_row($result)) {
            if ($GLOBALS['multilingual']) {
                $the_lang = "";
            } else {
                $the_lang = mxCreateImage('images/language/flag-' . $elanguage . '.png', '', 0, 'hspace="3"');
            }
            if (!empty($subtitle)) {
                $subtitle = "<br />($description)<br /><br />";
            } else {
                $subtitle = "";
            }
            if (MX_IS_ADMIN) {
                echo "<h3><strong><big>&middot;</big></strong> $the_lang <a href=\"modules.php?name=$module_name&amp;op=list_content&amp;eid=$eid\">$title</a></h3>$description<br />[&nbsp;<a href=\"" . adminUrl($module_name, 'edit', 'eid=' . $eid) . "\">" . _EDIT . "</a> | <a href=\"" . adminUrl($module_name, 'change_status', 'eid=' . $eid . '&amp;active=1') . "\">" . _DEACTIVATE . "</a> | <a href=\"" . adminUrl($module_name, 'delete', 'eid=' . $eid) . "\">" . _DELETE . "</a>&nbsp;]<br /><br />";
            } else {
                echo "<h3><strong><big>&middot;</big></strong> $the_lang <a href=\"modules.php?name=$module_name&amp;op=list_content&amp;eid=$eid\">$title</a></h3> $description<br /><br />";
            }
        }
        echo '</div>';
	 
		if (MX_IS_ADMIN) {
			$result = sql_query("SELECT eid, title, description, elanguage from " . $prefix . "_encyclopedia WHERE active='0'");
			if (sql_num_rows($result) >= 1) {
				echo "<br /><br /><h2>" . _YOURADMININACTIVELIST . "</h2>";
				echo '<div style="padding-left: 30px;">';
				while (list($eid, $title, $description, $elanguage) = sql_fetch_row($result)) {
					if ($GLOBALS['multilingual']) {
						$the_lang = "";
					} else {
						$the_lang = mxCreateImage('images/language/flag-' . $elanguage . '.png', '', 0, 'hspace="3"');
					}
					if (!empty($subtitle)) {
						$subtitle = " ($subtitle) ";
					} else {
						$subtitle = " ";
					}
					echo "<h3><strong><big>&middot;</big></strong> $the_lang <a href=\"modules.php?name=" . $module_name . "&amp;op=content&amp;eid=$eid\">$title</a></h3>$description<br />[&nbsp;<a href=\"" . adminUrl($module_name, 'edit', 'eid=' . $eid) . "\">" . _EDIT . "</a> | <a href=\"" . adminUrl($module_name, 'change_status', 'eid=' . $eid . '&amp;active=0') . "\">" . _ACTIVATE . "</a> | <a href=\"" . adminUrl($module_name, 'delete', 'eid=' . $eid) . "\">" . _DELETE . "</a>&nbsp;]<br /><br />";
				}
				echo '</div>';
			}
		}
		CloseTable();
		include("footer.php");
		
	} else {
		// nur die eine aufrufen
		list($eid, $title, $description, $elanguage) = sql_fetch_row($result);
		$_REQUEST['eid']=$eid;
		unset($result);
		list_content();
		
	}
    return;
}



$op = (empty($_REQUEST['op'])) ? '' : $_REQUEST['op'];

switch ($op) {
    case "content":
        content();
        break;

    case "list_content":
        list_content();
        break;

    case "terms":
        terms();
        break;

    default:
        list_themes();
        break;
}

?>