<?php
/**
 * This file is part of
 *
 * ......................
 *
 * for pragmamx (www.pragmamx.org)
 *
 * $Revision 1.0 $
 * $Author: tora60 $
 * $Date: 2014-03-07 13:28:11 $
 */

defined('mxMainFileLoaded') or die('access denied');

include_once(dirname(dirname(__FILE__)) . "/includes/functions.php");

/**
 * theme_admin
 *
 * @package
 * @author ???
 * @copyright Copyright (c) 2014
 * @version $Id: admin.php,v 1.2 2014-03-07 13:28:11 tora60 Exp $
 * @access public
 */
class theme_admin {
    private $errors = array();
    private $form = null;
    private $homepage = '';
    private static $__set = array(); // Konfiguration
    private $kf = null;

    private static $_config = null;

    /**
     * class::__construct()
     *
     * @param string $parameter
     */
    function __construct ($parameter = "")
    {
        global $prefix;

        mxGetLangfile(__DIR__);

        $this->themename = basename(dirname(__DIR__));

        $this->kf = new theme_functions($this->themename);
        $this->op = $parameter;
        self::$_config = $this->config_load();
        $this->main($this->op);
    }

    /**
     * class::__get()
     *
     * @param mixed $value_name
     * @return
     */
    public function __get($value_name)
    {
        if (isset(self::$__set[$value_name])) {
            return self::$__set[$value_name];
        }
        return false;
    }

    /**
     * class::__set()
     *
     * @param mixed $name
     * @param mixed $val
     * @return
     */
    public function __set($name, $val)
    {
        self::$__set[$name] = $val;
    }

    /**
     * class::main()
     *
     * @param string $action
     * @return
     */
    function main ($op)
    {
        $info2 = $this->themename;
        $tb = load_class('AdminForm', "adminFormMain");
		$redirect=false;
		$custom_css=PMX_THEMES_DIR . DS . $this->themename . DS . "style".DS."custom.css";
		/* definitionen voreinstellungen */
		
		
        switch (pmxAdminForm::CheckButton()) {
            case "save":
				$redirect=true;
			case "accept":
			    
                $temp = $_POST['config'];        
				$config = $this->config_load();

				switch (true) {
					case (trim($temp['sitename']=="")):
						$temp['sitename']=$GLOBALS['sitename'];
					case (trim($temp['slogan']=="")):
						$temp['slogan']=$GLOBALS['slogan'];
				}
				$temp=array_merge($config,$temp);
				/* CSS rausfiltern */
				$ccss=$temp['custom_css'];
				if ($ccss) {
					file_put_contents($custom_css,$ccss);
				}
				
				unset($temp['custom_css'],$ccss);
				
                $this->config_save ($temp) ;
                if ($redirect) mxRedirect("admin.php?op=themes#".$info2, _CHANGESAREOK, 1);
                break;
			case "cancel":
				mxRedirect("admin.php?op=themes#".$info2);
				break;
                
		}

        $config = $this->config_load();
		
		$config['custom_css']=(file_exists($custom_css))?file_get_contents($custom_css):"";

		echo "<h3>".$info2."</h3>";
		$themeimg="themes/".$this->themename."/theme_thumbnail.png";
		$themeimage= (file_exists($themeimg))?"<img src=\"".$themeimg."\" style=\"width:100px;float:left;\" />":"no preview";
		//$credit=mxcredit_shortinfo_string(PMX_THEMES_DIR . DS. $this->themename . DS . "setup.pmx.php");//$credits;
		//$themeinfo = mxcredit_prepare($credit);

        $tb = load_class('AdminForm', "adminFormMain");
        $tb->tb_text = $themeimage;
        $tb->tb_direction = 'right';
        $tb->infobutton = true;
        $tb->tb_pic_heigth = 22;
        $tb->cssclass = "toolbar1";
        $tb->homelink = false;
		$tb->formtabs = true;

		
        $tb->addToolbar("save");
        $tb->addToolbar("accept");
		$tb->addToolbarlink("preview","modules.php?name=Themetest&themeselect=".$this->themename );
        $tb->addToolbar("cancel");
		
        $tb->addToolbarLink("cpanel", "admin.php?op=themes#".$this->themename);

		$farbschema=array("blue"=>"blue","green"=>"green");
		
        /* Form elements */
        $tb->addFieldSet("head", _SETTINGS, "", false);
        $tb->add("head", "input", "config[sitename]", $config['sitename'], _THEME_TITLE, "", 50, 50);
        $tb->add("head", "input", "config[slogan]", $config['slogan'], _THEME_SLOGAN, "", 50, 50);
        $tb->add("head", "input", "config[head_css_menu]", $config['head_css_menu'], _THEME_MENU, "", 50, 50);
		
		$tb->add("head", "input", "config[foot_css_menu]", $config['foot_css_menu'], _THEME_FOOTMENU, _THEME_FOOTMENU_TXT, 50, 50);
		$tb->add("head", "yesno", "config[breadcrump]", $config['breadcrump'], _THEME_BREADCRUMP, "");
		
        $tb->add("head", "yesno", "config[perex]", $config['perex'], _THEME_PEREX);
        $tb->add("head", "hidden", "config[banner][head]", 0); 
		$tb->add("head", "yesno", "config[banner][foot]", $config['banner']['foot'], _THEME_BANNER_FOOT); 
		$tb->add("head", "hidden", "ok", "1");

        
		
					/* social links */		
		$tb->addFieldSet("social", _THEME_SOCIAL_SETTINGS, "", true);
		//mxDebugFuncVars($config['sociallinks']);
		foreach ($config['sociallinks'] as $channel=>$value)
		{
			$linkimage=mxCreateImage(PMX_THEMES_DIR . DS. $this->themename . DS . "style".DS."images".DS."social".DS.$channel.".png","",array("style"=>"width:20px;height:auto;"));
			$tb->add("social", "input", "config[sociallinks][".$channel."]", $config['sociallinks'][$channel], $linkimage . "&nbsp;".$channel, _THEME_SOCIAL_SETTINGS, 80, 80);
		}
		$socialimagesets=array();
		
		/* die Imagesets suchen */
		$setdir= PMX_THEMES_DIR . DS. $this->themename . DS . "images" . DS . "social" . DS . "*" . DS . 'facebook.png';
		
		foreach (glob($setdir) as $filename) {
			$filename=basename(dirname($filename));
			$socialimagesets[$filename]=$filename;
		}	
		
		if (count($socialimagesets)) {
			
			$tb->add("social","select","config[socialsets]",$config['socialsets'],_THEME_SOCIALSET,"",1,$socialimagesets);
		}
		
		$tb->addFieldSet("text", _THEME_DEF_TEXT, "", true);
		
		$tb->add("text","editor","config[foot_text]", stripslashes($config['foot_text']), _THEME_FOOT_TEXT);
        
		$tb->addFieldSet("blocks", _THEME_BLOCKS, _THEME_BLOCKS_TXT, true);
		$tb->add("blocks","textarea","config[blocks_left]", $config['blocks_left'], _THEME_BLOCKS_LEFT);
		$tb->add("blocks","textarea","config[blocks_right]", $config['blocks_right'], _THEME_BLOCKS_RIGHT);
		$tb->add("blocks","textarea","config[blocks_both]", $config['blocks_both'], _THEME_BLOCKS_BOTH);

		$tb->addFieldSet("cssedit", _THEME_CUSTOM_CSS, _THEME_CUSTOM_CSS_TXT, true);
		$tb->add("cssedit","textarea","config[custom_css]", $config['custom_css'], "","",20,array("style"=>"width:100%;height:20em;"));

		$tb->add("text","editor","config[content_foot_text]", stripslashes($config['content_foot_text']), _THEME_CONTENT_TEXT);
		$tb->addFieldSet("info2", _VERSION, "", false);
		$tb->add("info2","html",$this->load_credits());
        echo $tb->Show();

        
    }

    /**
     * class::config_save()
     * Konfiguration auslesen ....
     *
     * @param array $temp
     * @return
     */
    function config_save ($temp = array())
    {
        $this->kf->config_save($temp);
    }

    /**
     * class::config_load()
     *
     * @return
     */
    function config_load ()
    {
        $temp = $this->kf->config_load();
		$temp=mxStripSlashes($temp);
        return $temp;
    }
	
	
	function load_credits ()
	{
		$filename=PMX_THEMES_DIR . DS . $this->themename . DS . "setup.pmx.php";
			
		if (function_exists("mxcredit_load_setuppmx")) {
				return mxcredit_get_setuppmx_string($filename);
			} else {
				mxGetLangfile(PMX_LANGUAGE_DIR . DS . 'credits');
				if (!file_exists($filename)) return "";
				$info="";
				include($filename);
				$file = basename(dirname($filename));
				if (is_callable($credits)){
					$credit=$credits();
				} else {
					$credit=$credits;
					if (!is_array($credit))$info .= '<h4>' . $file . '</h4>';
				}
				if ($credit) {
					$info .= '<div class="content">' . mxcredit_prepare($credit) . '</div>';
					$credits=NULL;
				}
				return $info;
		}		
	}
}

if (!isset($op)) $op = "";
$tmp = new theme_admin($op);
$tmp = null;

?>