<?php
/**
 * This file is part of Theme for 
 * pragmaMx - Web Content Management System.
 *
 * $template: pmx_base $
 * $Revision: 1 $
 * 
 * $Author: pragmaMx $
 * $Date: 2023-11-04 16:01:22 $
 */ 

defined('mxMainFileLoaded') or die('access denied');

define('_THISTHEME_', dirname(__FILE__));
define('_THISTHEMENAME_',basename(dirname(__FILE__)));
/* Sprachdatei auswaehlen */
if (@file_exists(_THISTHEME_ . '/language/lang-' . $GLOBALS['currentlang'] . '.php')) {
    include_once(_THISTHEME_ . '/language/lang-' . $GLOBALS['currentlang'] . '.php');
} else {
    include_once(_THISTHEME_ . '/language/lang-german.php');
}
include_once(_THISTHEME_ . '/includes/functions.php');
if (file_exists(_THISTHEME_ ."/custom.php")) include(_THISTHEME_ ."/custom.php");

defined('MX_MOBILE_DEVICE') or define('MX_MOBILE_DEVICE',false);

global $themesetting, $theme_mobile; // global muss drin bleiben, weil das in einer Funktion includet wird !!

$themesetting = array();
$theme_config = new theme_functions(_THISTHEMENAME_);

$themesetting['banner']['head']=0;
$themesetting['banner']['foot']=0;

$themesetting2=$theme_config->config_load();

$themesetting=array_merge($themesetting,$themesetting2);
$perex2=$themesetting['perex'];
$themesetting['perex']=false;

/* guggen, was fuer ein Browser am werkeln ist */
$theme_browser = load_class('Browser');
$themesetting['browser']=" ".$theme_browser->browser();

/**
 * Themesettingsdatei includen
 */

include(_THISTHEME_ . '/settings.php');

/**
 * spezielle Themefunktionen und Bereichsdefinitionen
 */
include_once(_THISTHEME_ . '/includes/theme.functions.php');

/* nur wenn theme.php normal verwendet wird, nicht fuer CSS */
if (defined('PMX_VERSION')) {

    /* zu alte pragmaMx-Version */
    if (version_compare(PMX_VERSION, '2.7', '<')) {
        die('<br />Sorry, theme "' . basename(_THISTHEME_) . '" requires pragmaMx version >= 2.7.');
    }

    /* die themeEngine laden */
    include_once(PMX_SYSTEM_DIR . '/mx_themes.php');

    /* bei Bedarf den Dokumenttyp anpassen :) */
    if (!theme_check_xhtmldoctype()) {
        $GLOBALS['DOCTYPE'] = 3;
    }
}

/* PNG-Fix für alten IE < 7 */
if ($theme_browser->msie && $theme_browser->version < 7) {
    pmxHeader::add_style(_THISTHEME_."/style/style.ie7.css");
}


/* HTML-Fehlerbereinigung abschalten, da pmx Probleme hat mit HTML5-Tags */

$GLOBALS['TidyOutput']=0;

$viewport='content="initial-scale = 1.0, maximum-scale = 1.0, user-scalable = no, width = device-width"';
pmxHeader::set_meta("viewport",$viewport);
pmxHeader::add('<!--[if lte IE 7]><link rel="stylesheet" href="style/style.ie7.css" media="screen" /><![endif]-->');

/* Favicon and touch-icon */

if (file_exists(_THISTHEME_."/images/favicon.svg")) pmxHeader::add("<link rel=\"icon\" href=\"/themes/" ._THISTHEMENAME_. "/images/favicon.svg\" type=\"image/svg+xml\" size=\"any\"/>");
if (file_exists(_THISTHEME_."/images/favicon.png")) pmxHeader::add("<link rel=\"icon\" href=\"/themes/" ._THISTHEMENAME_. "/images/favicon.png\" type=\"image/png\" size=\"32x32\"/>");
if (file_exists(_THISTHEME_."/images/favicon.png")) pmxHeader::add("<link rel=\"icon\" href=\"/themes/" ._THISTHEMENAME_. "/images/favicon.png\" type=\"image/png\" size=\"96x96\" />");
if (file_exists("/apple-touch-icon.png")) pmxHeader::add("<link rel=\"apple-touch-icon.png\" href=\"/themes/" ._THISTHEMENAME_. "/images/apple-touch-icon.png\" type=\"image/png\" size=\"180x180\" />");
if (file_exists("/mstile-144x144.png")) pmxHeader::add("<link rel=\"mstile-144x144.png\" href=\"/apple-touch-icon.png\" />");

if (file_exists(_THISTHEME_."/images/favicon.ico")) pmxHeader::add("<link rel=\"shortcut icon\" href=\"" . PMX_HOME_URL . "/themes/" ._THISTHEMENAME_. "/images/favicon.ico\" type=\"image/x-icon\" />");
//if (file_exists(_THISTHEME_."/favicon.ico")) pmxHeader::add("<link rel=\"shortcut icon\" href=\"" . PMX_HOME_URL . "/themes/" ._THISTHEMENAME_. "/favicon.ico\" type=\"image/x-icon\" />");

/* Jquery auf alle Fälle einbinden */
pmxHeader::add_jquery();


/* CSS Dateien einbinden */


		pmxHeader::add_style(_THISTHEME_."/style/pragma.css");
		pmxHeader::add_style(_THISTHEME_."/style/hmenu.css");
		pmxHeader::add_style(_THISTHEME_."/style/news.css");
		

if (file_exists(_THISTHEME_ ."/style/script.js"))pmxHeader::add_script(_THISTHEME_ ."/style/script.js");
if (file_exists(_THISTHEME_."/style/style.responsive.css"))pmxHeader::add_style(_THISTHEME_."/style/style.responsive.css");
if (file_exists(_THISTHEME_."/style/script.responsive.js"))pmxHeader::add_script(_THISTHEME_."/style/script.responsive.js");
if (file_exists(_THISTHEME_."/style/ui/jquery-ui.css"))pmxHeader::add_style(_THISTHEME_."/style/ui/jquery-ui.css");
if (file_exists(_THISTHEME_."/style/news.css"))pmxHeader::add_style(_THISTHEME_."/style/news.css");
if (file_exists(_THISTHEME_."/style/custom.css"))pmxHeader::add_style(_THISTHEME_."/style/custom.css");


/* ----- top-Button -------------- */
pmxHeader::add_style_code(
"#myHomeBtn {
			display: none;
			position: fixed;
			bottom: 1.5em;
			right: 2em;
			z-index: 999;
			cursor: pointer;

			}"
);
 
pmxHeader::add_body_script_code('

 window.onscroll = function() {scrollFunction()};
 function scrollFunction() {
				if (document.body.scrollTop > 100 || document.documentElement.scrollTop > 100) {
					document.getElementById("myHomeBtn").style.display = "block";
				} else {
					document.getElementById("myHomeBtn").style.display = "none";
				}
			}

			// When the user clicks on the button, scroll to the top of the document
			function topFunction() {
				/*document.body.scrollTop = 0;
				document.documentElement.scrollTop = 0;*/
				window.scrollBy({ 
								  top: -100000, // could be negative value
								  left: 0, 
								  behavior: \'smooth\' 
								});
			}'); 
pmxHeader::add_body('<button onclick="topFunction()" class="button" id="myHomeBtn" title="'._TOP.'">'._TOP.'</button>');	

?>