<?php
/**
 * This file is part of Theme for 
 * pragmaMx - Web Content Management System.
 *
 * $template : [THEMENAME] $
 * $Revision: [TEMPLATEVERSION] $
 * 
 * $Author: [TEMPLATEAUTHOR] $
 * $Date: [TEMPLATEDATE] $
 */

defined('mxMainFileLoaded') or die('access denied');

/**
 * theme_functions
 *
 * @package
 * @author ????
 * @copyright Copyright (c) 2014
 * @version $Id: functions.php,v 1.2 2014-03-07 13:28:11 tora60 Exp $
 * @access public
 */
class theme_functions {
    private static $config;
    private static $__set = array(); // Konfigurtion

    /**
     * class::__construct()
     *
     * @param mixed $parameter
     */
    function __construct ($parameter = null)
    {
        $this->themename = $parameter;
        self::$config = load_class("Config", $this->themename);
		
    }

    /**
     * class::GetDefaultConfig()
     *
     * @return
     */
    static function GetDefaultConfig()
    {
        $temp = array(
            'colorschema' => 'default',
			'rightblocks' => true,
			'sitename'=>$GLOBALS['sitename'],
			'slogan'=>$GLOBALS['slogan'],
			'head_css_menu'=>'MENU',
			'top_css_menu'=>'',
			'foot_css_menu'=>'',
			'facebooklink' => '',
            'rsslink' => 'modules.php?name=rss',
            'twitterlink' => '',
			'perex'=>'0',
			'banner'=> array('head'=>0,'foot'=>0),
			'breadcrump'=>1,
			'top_text' => '',
			'foot_text' =>'',
            'headrow' =>'',
			'content_foot_text' =>'',
			'headertext'=>'',
			'blocks_left'=>'Admin',
			'blocks_right'=>'',
			'blocks_both'=>'',
			'socialsets'=>'default',
			'sociallinks'=>array(
						'rss' => 'modules.php?name=rss',
						'facebook' => '',
						'flickr'=>'',
						'instagram'=>'',
						'twitter' => '',
						'vimeo'=>'',
						'youtube'=>'',
						'tumblr'=>'',	
						'linkedin'=>'',	
						'xing'=>'',	
						'pinterest'=>'',
						'tiktok'=>'',
					),			
            			
            );
        return $temp;
    }

    /**
     * class::config_save()
     * Konfiguration auslesen ....
     *
     * @param array $temp
     * @return
     */
    public function config_save ($temp = array())
    {
        $themename = $this->themename;
        self::$config->setSection($themename, $temp);
        return;
    }

    /**
     * class::config_load()
     *
     * @return
     */
    public function config_load ()
    {
        $themename = $this->themename;
		$temp1 = $this->GetDefaultConfig();
		//
		$temp2=self::$config->getSection($themename);
        $temp = array_merge($temp1,$temp2);
		if (array_key_exists('socilalinks',$temp)) $temp['sociallinks']=array_merge($temp1['sociallinks'],$temp2['sociallinks']);

        return $temp;
    }
    /**
     * class::__get()
     *
     * @param mixed $value_name
     * @return
     */
    public function __get($value_name)
    {
        if (isset(self::$__set[$value_name])) {
            return self::$__set[$value_name];
        }
        return false;
    }

    /**
     * class::__set()
     *
     * @param mixed $name
     * @param mixed $val
     * @return
     */
    public function __set($name, $val)
    {
        self::$__set[$name] = $val ;
    }
}

?>